<?php
	/**************************************************************************\
	* eGroupWare API - Accounts manager for the contacts class                 *
	* This file written by Miles Lott <milosch@groupwhere.org>                 *
	* View and manipulate account records using the contacts class             *
	* Copyright (C) 2000, 2001 Miles Lott                                      *
	* -------------------------------------------------------------------------*
	* This library is part of the eGroupWare API                               *
	* http://www.egroupware.org/api                                            * 
	* ------------------------------------------------------------------------ *
	* This library is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU Lesser General Public License as published by *
	* the Free Software Foundation; either version 2.1 of the License,         *
	* or any later version.                                                    *
	* This library is distributed in the hope that it will be useful, but      *
	* WITHOUT ANY WARRANTY; without even the implied warranty of               *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
	* See the GNU Lesser General Public License for more details.              *
	* You should have received a copy of the GNU Lesser General Public License *
	* along with this library; if not, write to the Free Software Foundation,  *
	* Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
	\**************************************************************************/

	/* $Id: class.accounts_contacts.inc.php 20295 2006-02-15 12:31:25Z  $ */


	/*
	THIS NEEDS WORK!!!!!!!!! - Milosch
	But it is a lot closer now...
	*/
	$GLOBALS['egw_info']['server']['global_denied_users'] = array(
		'root'     => True, 'bin'      => True, 'daemon'   => True,
		'adm'      => True, 'lp'       => True, 'sync'     => True,
		'shutdown' => True, 'halt'     => True, 'ldap'     => True,
		'mail'     => True, 'news'     => True, 'uucp'     => True,
		'operator' => True, 'games'    => True, 'gopher'   => True,
		'nobody'   => True, 'xfs'      => True, 'pgsql'    => True,
		'mysql'    => True, 'postgres' => True, 'oracle'   => True,
		'ftp'      => True, 'gdm'      => True, 'named'    => True,
		'alias'    => True, 'web'      => True, 'sweep'    => True,
		'cvs'      => True, 'qmaild'   => True, 'qmaill'   => True,
		'qmaillog' => True, 'qmailp'   => True, 'qmailq'   => True,
		'qmailr'   => True, 'qmails'   => True, 'rpc'      => True,
		'rpcuser'  => True, 'amanda'   => True, 'apache'   => True,
		'pvm'      => True, 'squid'    => True, 'ident'    => True,
		'nscd'     => True, 'mailnull' => True, 'cyrus'	   => True,
		'backup'   => True
	);

	$GLOBALS['egw_info']['server']['global_denied_groups'] = array(
		'root'      => True, 'bin'       => True, 'daemon'    => True,
		'sys'       => True, 'adm'       => True, 'tty'       => True,
		'disk'      => True, 'lp'        => True, 'mem'       => True,
		'kmem'      => True, 'wheel'     => True, 'mail'      => True,
		'uucp'      => True, 'man'       => True, 'games'     => True,
		'dip'       => True, 'ftp'       => True, 'nobody'    => True,
		'floppy'    => True, 'xfs'       => True, 'console'   => True,
		'utmp'      => True, 'pppusers'  => True, 'popusers'  => True,
		'slipusers' => True, 'slocate'   => True, 'mysql'     => True,
		'dnstools'  => True, 'web'       => True, 'named'     => True,
		'dba'       => True, 'oinstall'  => True, 'oracle'    => True,
		'gdm'       => True, 'sweep'     => True, 'cvs'       => True,
		'postgres'  => True, 'qmail'     => True, 'nofiles'   => True,
		'ldap'      => True, 'backup'  	 => True
	);

	class accounts_
	{
		var $db;
		var $contacts;
		var $account_id;
		var $data;
		var $debug = False;
		var $qcols = array(
			'fn'                     => 'fn',
			'n_given'                => 'n_given',
			'n_family'               => 'n_family',
			'account_lastlogin'      => 'account_lastlogin',
			'account_lastloginfrom'  => 'account_lastloginfrom',
			'account_lastpwd_change' => 'account_lastpwd_change',
			'account_status'         => 'account_status',
			'account_expires'        => 'account_expires'
		);

		function accounts_()
		{
			$this->db       = $GLOBALS['egw']->db;
			$this->contacts =& CreateObject('phpgwapi.contacts',0);
		}

		function makeobj()
		{
			if(!$this->contacts)
			{
				$this->contacts =& CreateObject('phpgwapi.contacts','0');
			}
		}

		function read_repository()
		{
			$this->makeobj();

			$allValues = $this->contacts->read_single_entry($this->account_id,$this->qcols);

			/* Now dump it into the array */
			$this->data['userid']            = $allValues[0]['lid'];
			$this->data['account_id']	     = $allValues[0]['id'];
			$this->data['account_lid'] 	     = $allValues[0]['lid'];
			$this->data['account_type']      = $allValues[0]['tid'];
			$this->data['firstname']   	     = $allValues[0]['n_given'];
			$this->data['lastname']    	     = $allValues[0]['n_family'];
			$this->data['fullname']    	     = $allValues[0]['fn'];
			$this->data['lastlogin']         = $allValues[0]['account_lastlogin'];
			$this->data['lastloginfrom']     = $allValues[0]['account_lastloginfrom'];
			$this->data['lastpasswd_change'] = $allValues[0]['account_lastpwd_change'];
			$this->data['status']            = $allValues[0]['account_status'];
			$this->data['expires']           = $allValues[0]['account_expires'];

			return $this->data;
		}

		function save_repository()
		{
			$this->makeobj();

			$entry['id']                        = $this->data['account_id'];
			$entry['lid']                       = $this->data['account_lid'];
			$entry['tid']                       = $this->data['account_type'];
			$entry['fn']                        = sprintf("%s %s", $this->data['firstname'], $this->data['lastname']);
			$entry['n_family']                  = $this->data['lastname'];
			$entry['n_given']                   = $this->data['firstname'];
			$entry['account_lastlogin']         = $this->data['lastlogin'];
			$entry['account_lastloginfrom']     = $this->data['lastloginfrom'];
			$entry['account_lastpasswd_change'] = $this->data['lastpwd_change'];
			$entry['account_status']            = $this->data['status'];
			$entry['account_expires']           = $this->data['expires'];

			if($this->debug) { echo '<br>Updating entry:<br>' . var_dump($entry); }
			$this->contacts->update($entry['id'],0,$entry,'public','',$entry['tid']);
		}

		function add($account_name, $account_type, $first_name, $last_name, $passwd = False) 
		{
			$this->create($account_name, $account_type, $first_name, $last_name, $passwd);
		}

		function delete($accountid = '')
		{
			$this->makeobj();

			if($this->debug) { echo '<br>Deleting entry:<br>' . $account_id; }
			$account_id = get_account_id($accountid);
			$this->contacts->delete($account_id);
		}

		function get_list($_type='both')
		{
			$this->makeobj();

			switch($_type)
			{
				case 'accounts':
					$filter = 'tid=u';
					break;
				case 'groups':
					$filter = 'tid=g';
					break;
				default:
					$filter = 'tid=u,tid=g';
			}

			$allValues = $this->contacts->read(0,0,$this->qcols,'',$filter);

			/* get user information for each user/group */
			for($i=0;$i<count($allValues);$i++)
			{
				$accounts[] = Array(
					'account_id'        => $allValues[$i]['id'],
					'account_lid'       => $allValues[$i]['lid'],
					'account_type'      => $allValues[$i]['tid'],
					'account_firstname' => $allValues[$i]['n_given'],
					'account_lastname'  => $allValues[$i]['n_family'],
					'account_status'    => $allValues[$i]['account_status'],
					'account_expires'   => $allValues[$i]['account_expires']
				);
			}

			return $accounts;
		}

		function name2id($account_lid)
		{
			$qcols = array('id' => 'id');
			$this->makeobj();
			$allValues = $this->contacts->read(0,0,$qcols,'',"lid=".$account_lid);

			if($allValues[0]['id'])
			{
				return (int)$allValues[0]['id'];
			}
			else
			{
				return False;
			}
		}

		function id2name($account_id)
		{
			$this->makeobj();

			$allValues = $this->contacts->read_single_entry($account_id);
			if($this->debug) { echo '<br>id2name: '.$allValues[0]['lid']; }

			if($allValues[0]['lid'])
			{
				return $allValues[0]['lid'];
			}
			else
			{
				return False;
			}
		}

		function get_type($accountid = '')
		{
			$this->makeobj();
			$account_id = get_account_id($accountid);

			$allValues = $this->contacts->read_single_entry($account_id);

			if ($allValues[0]['tid'])
			{
				return $allValues[0]['tid'];
			}
			else
			{
				return False;
			}
		}

		function exists($account_lid)
		{
			$this->makeobj();
			if(is_int($account_lid))
			{
				$account_id = $account_lid;
				settype($account_lid,'string');
				$account_lid = $this->id2name($account_id);
			}

			$allValues = $this->contacts->read(0,0,array('n_given' => 'n_given'),'','lid='.$account_lid);

			if ($allValues[0]['id'])
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function create($account_info)
		{
			$this->makeobj();

			if (!$$account_info['account_id'])
			{
				$account_info['account_id'] = $this->get_nextid();
			}
			$owner = $GLOBALS['egw_info']['user']['account_id'];
			$entry['id']       = $account_info['account_id'];
			$entry['lid']      = $account_info['account_lid'];
			$entry['n_given']  = $account_info['account_firstname'];
			$entry['n_family'] = $account_info['account_lastname'];
			$entry['password'] = $account_info['account_passwd'];
			$entry['account_status']   = $account_info['account_status'];
			$entry['account_expires']  = $account_info['account_expires'];

			if($this->debug) { echo '<br>Adding entry:<br>' . var_dump($entry); }
			/* 'public' access, no category id, tid set to account_type */
			$this->contacts->add(0,$entry,'public','',$account_info['account_type']);
			return;
		}

		function auto_add($accountname, $passwd, $default_prefs = False, $default_acls = False, $expiredate = 0, $account_status = 'A')
		{
			if (! $expiredate)
			{
				// expire in 30 days by default
				$expiredate = time() + ( ( 60 * 60 ) * (30 * 24) );
			}

			$default_group_id  = $this->name2id($GLOBALS['egw_info']['server']['default_group_lid']);
			if (!$default_group_id)
			{
				$default_group_id = (int) $this->name2id('Default');
			}
			$primary_group = $GLOBALS['auto_create_acct']['primary_group'] &&
				$this->get_type((int)$GLOBALS['auto_create_acct']['primary_group']) == 'g' ?
				(int) $GLOBALS['auto_create_acct']['primary_group'] : $default_group_id;

			$acct_info = array(
				'account_lid'       => $accountname,
				'account_type'      => 'u',
				'account_passwd'    => $passwd,
				'account_firstname' => $GLOBALS['auto_create_acct']['firstname'] ? $GLOBALS['auto_create_acct']['firstname'] : 'New',
				'account_lastname'  => $GLOBALS['auto_create_acct']['lastname'] ? $GLOBALS['auto_create_acct']['lastname'] : 'User',
				'account_status'    => $account_status,
				'account_expires'   => mktime(2,0,0,date('n',$expiredate), (int)date('d',$expiredate), date('Y',$expiredate)),
				'account_primary_group' => $primary_group,
			);
			if (isset($GLOBALS['auto_create_acct']['email']) == True && $GLOBALS['auto_create_acct']['email'] != '')
			{
				$acct_info['account_email'] = $GLOBALS['auto_create_acct']['email'];
			}
			elseif(isset($GLOBALS['egw_info']['server']['mail_suffix']) == True && $GLOBALS['egw_info']['server']['mail_suffix'] != '')
			{
				$acct_info['account_email'] = $accountname . '@' . $GLOBALS['egw_info']['server']['mail_suffix'];
			}

			$this->create($acct_info);
			$accountid = $this->name2id($accountname);

			if ($accountid)
			{
				/* If we have a primary_group, add it as "regular" eGW group (via ACL) too. */
				if ($primary_group)
				{
					$GLOBALS['egw']->acl->add_repository('phpgw_group', $primary_group,$accountid,1);
				}
				// call hook to notify other apps about the new account
				$GLOBALS['hook_values']['account_lid']	= $acct_info['account_lid'];
				$GLOBALS['hook_values']['account_id']	= $accountid;
				$GLOBALS['hook_values']['new_passwd']	= $acct_info['account_passwd'];
				$GLOBALS['hook_values']['account_status'] = $acct_info['account_status'];
				$GLOBALS['hook_values']['account_firstname'] = $acct_info['account_firstname'];
				$GLOBALS['hook_values']['account_lastname'] =  $acct_info['account_lastname'];
				$GLOBALS['egw']->hooks->process($GLOBALS['hook_values']+array(
					'location' => 'addaccount'
				),False,True);  /* called for every app now, not only enabled ones */
			}
			return $accountid;
		}
	}
