/* -*- c++ -*- */
#ifndef __NETWORKING_H__
#define __NETWORKING_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2002, 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <netdb.h>
#include <arpa/inet.h>
#include <regex.h>

#ifdef OPENSSL_SUPPORT
# include <openssl/ssl.h>
#endif

#include "str.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

enum status {
        NET_DOWN,
        NET_RESOLVING,
        NET_CONNECTING,
        NET_READY,
        NET_READING_DATA,
        NET_WRITING_DATA,
        NET_TIMED_OUT,
};

/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/

#ifdef __cplusplus

class Net;

#endif

/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/

#ifdef __cplusplus

struct nlist {
        struct nlist *next;
        Net          *net;
};


class Net {

private:
        int      sock;

#ifdef OPENSSL_SUPPORT
        SSL     *ssl;
#else
        void    *ssl;
#endif

        int      progress;
        str_t   *progress_desc;
        int      bytes_expected;
        int      bytes_received;

        int      total_sent;
        int      total_recv;
        int      time_start;

        bool     is_compiled;
        regex_t  terminator;
        int      read_size;
        int      read_fill;
        char    *read_buffer;

        int      send_size;
        int      send_sent;
        char    *send_buffer;

        static struct nlist *nlist;


        bool resolve_host (void);
        bool make_connection (bool secure);
        void shutdown_connection (void);
        bool check_read_write_ret (int ret, const char *s);

        static void add (Net *net);
        static void remove (Net *net);


protected:
        enum status     status;

        char           *server_name;

        struct in_addr  local_addr;
        unsigned short  local_port;
        struct in_addr  server_addr;
        unsigned short  server_port;

        void expect (int size, char *desc, ...);
        void send_progress (char *desc, ...);
        void net_recv (const char *re);
        void net_send (char *buf, int size);
        void combo (char *buf, int size, const char *re);

        void send_fun (void);
        virtual void recv_fun (char *buf, int len) = 0;
        virtual void on_shutdown (void) = 0;


public:
        Net (void);
        ~Net (void);
        bool open (const char *hostname, unsigned short port, bool secure);
        void close (bool callback = true);
        bool is_connected (void);


        static Net *find_by_sock (int fd);
        void data_reader (void);
        void data_sender (void);
};

#endif /* __cplusplus */

/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void net_init (void);
extern void net_free_resources (void);

#ifdef __cplusplus
}
#endif

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER networking.h
 *
 ****************************************************************************/
#endif
