/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _BTP_NODE_H
#define _BTP_NODE_H

#include <glib.h>

/* TODO: part of the reason of separating BtpNode and BConn is so we
   can keep BtpNodes that we aren't connected to.  Currently, we
   always have a conn associated with the BtpNode, even if we aren't
   connected. */

typedef struct _BtpNode
{
  gchar* 	hostname;
  gint   	port;

  struct _BConn*	conn;
  struct _BtpTree*  	tree;

  /* Is the node being deleted? */
  gboolean	is_deleting;	


  /* Would the node make a bad parent? (because it sent an error? or
     wouldn't accept a switch?)  If this happens, don't make it my
     parent. */
  gboolean 	is_bad_parent;	

  /* Following */
  /* Set if a previous best potential parent switched to this node.
     We can switch to this node in the hope of then switching to that
     good node. */
  gboolean	follow;		 /* Attempt to follow to good node */
  gint		follow_distance; /* Distance to good node */

  /* Shortcuts */
  guint		overlay_distance; 	/* Delay to node throught overlay */
  guint		shortcut_ping_timeout;  /* Timeout for pinging shortcut   */
  guint		shortcut_add_timeout; 	/* Timeout for adding shortcut    */

  /* Data for upper level protocols */
  gpointer 	upper_data;


  /* TODO: Garbage collect time */


} BtpNode;


#include "b_conn.h"
#include "btp_tree.h"

BtpNode* btp_node_new (BtpTree* tree, gchar* hostname, gint port, BConn* conn);
gboolean btp_node_delete (BtpNode* node);

void	 btp_node_print (FILE* file, BtpNode* node);

#endif /* _BTP_NODE_H */
