/* $Id: e2_action.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2003-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file src/actions/e2_action.h
@brief action system header

This is the header file for the action system.
*/

#ifndef E2_ACTION_H
#define E2_ACTION_H

//these guide the creation of toolbars and menus
typedef enum
{
	E2_ACTION_TYPE_ITEM,	//all "non-special" (pseudo)actions default to this
	E2_ACTION_TYPE_SUBMENU,
	E2_ACTION_TYPE_FILE_ACTIONS,	//this is the context-menu widget
	E2_ACTION_TYPE_CUSTOM_COMMAND,	//UNUSED
	E2_ACTION_TYPE_PLUGINS,
	E2_ACTION_TYPE_SEPARATOR,
	E2_ACTION_TYPE_TEAR_OFF_MENU,
	E2_ACTION_TYPE_TOGGLE,
	E2_ACTION_TYPE_COMMAND_LINE,
	E2_ACTION_TYPE_BOOKMARKS,
	E2_ACTION_TYPE_CHECK_ITEM,  //UNUSED
	E2_ACTION_TYPE_FILTERS,	//UNUSED
	E2_ACTION_TYPE_DUMMY
} E2_ACTION_TYPE;

//flags for controlling display and/or use of actions
typedef enum
{
	E2_ACTION_EXCLUDE_GENERAL = 1 << 0,
	E2_ACTION_EXCLUDE_TOOLBAR = 1 << 1,	//not allowed as a toolitem action
	E2_ACTION_EXCLUDE_MENU = 1 << 2,	//not allowed as a menu-item action
	E2_ACTION_EXCLUDE_LAYOUT = 1 << 3,	//this is one of the pseudo-actions
	E2_ACTION_EXCLUDE_ACCEL = 1 << 4,	//not allowed as a key-binding or command
	E2_ACTION_EXCLUDE_TOGGLE = 1 << 5,

	E2_ACTION_INCLUDE_FILES = 1 << 16,
} E2_ACTION_EXCLUDE;
//all of the above
#define E2_ACTION_EXCLUDE_ALL 0x3f

typedef enum
{
	E2_TOGGLE_NONE,
	E2_TOGGLE_INIT,
	E2_TOGGLE_DESTROYED,
	E2_TOGGLE_REINIT,
} E2_TOGGLE_STATUS;

typedef struct _E2_Action
{
	gchar *name;	//string which identifies (i.e. actions hash key)
					//and/or runs the action, utf-8, translated
	gpointer func;	//function to run when action is initiated
	gboolean has_arg;	//TRUE if action-string includes context-specific argument(s) (stored BUT UNUSED!)
	E2_ACTION_TYPE type;	//enumerator which instructs toolbar creation
	E2_ACTION_EXCLUDE exclude;	//flags controlling use and display of the action
	gpointer data;	//data specified when action was registered,
					//sent to each instance as argument "action_data"
	gpointer data2; //more such data eg for toolbar usage
	GtkTreeRowReference *ref;	//reference to action's row in actions_store
} E2_Action;

typedef struct _E2_ActionRuntime
{
	E2_Action *action;
	gpointer data;
	gpointer data_free;
} E2_ActionRuntime;

GHashTable *toggles_hash;
#ifdef E2_TREEDIALOG
//make sure that the array size works for the extry action label(s)
//_A(109) may be used
#endif
#ifdef E2_KEYALIAS
//make sure this is big enough for all labels, 2 extra for this option
#define ACTION_LABEL_COUNT 110
#else
//make sure this is big enough for all labels
#define ACTION_LABEL_COUNT 108
#endif
typedef gchar *_action_labels[ACTION_LABEL_COUNT];
_action_labels action_labels;
#define _A(d) action_labels[d]

GtkTreeModel *e2_action_filter_store (gpointer data);
E2_Action *e2_action_register_simple (gchar *name, E2_ACTION_TYPE type,
	void *func, gpointer data, gboolean has_arg);
E2_Action *e2_action_register (gchar *name, E2_ACTION_TYPE type,
	void *func, gpointer data, gboolean has_arg,
	E2_ACTION_EXCLUDE exclude, gpointer data2);
gboolean e2_action_unregister (gchar *name);
E2_Action *e2_action_get (gchar *name);
E2_Action *e2_action_get_with_custom (gchar *name, gchar *arg, gchar **use_arg);
E2_Action* e2_action_check (gchar *command);
gboolean e2_action_run_simple (gchar *name, gpointer arg);
gboolean e2_action_run_simple_from (gchar *name, gpointer arg, gpointer from);
//void e2_action_run_cb (gpointer from, E2_ActionRuntime *rt);
#define e2_action_run_cb e2_action_run
gboolean e2_action_run (gpointer from, E2_ActionRuntime *rt);
E2_ActionRuntime *e2_action_pack_runtime (E2_Action *action, gpointer data,
	gpointer data_free);
void e2_action_free_runtime (E2_ActionRuntime *rt);

//void e2_actions_clean ();
//initialization things
void e2_action_setup_labels(void);
void e2_actions_init (void);

#endif //ndef E2_ACTION_H
