/* $Id: e2_date_filter_dialog.c 539 2007-07-18 11:52:43Z tpgww $

Copyright (C) 2003-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "emelfm2.h"
//#define _XOPEN_SOURCE /* required for strptime in glibc-2 */
#include <time.h>
#include "e2_dialog.h"
#include "e2_filelist.h"

enum
{
	MODIFIED_SINCE,
	MODIFIED_BEFORE,
	ACCESSED_SINCE,
	ACCESSED_BEFORE,
	CHANGED_SINCE,
	CHANGED_BEFORE,
	MAXDATECHOICES
};

typedef struct _E2_DtFltDlgData
{
	GtkWidget *dialog;
	GtkWidget *date_entry;
	GtkWidget *operation_combo;
	gint date_index;	//the date format array index to use
//	GtkWidget *menu_item;	//copy of pointer to clicked filters menu item
//	gboolean itemstate;
//	gboolean blocked = FALSE;	//flag to prevent toggles when not wanted
	ViewInfo *view;
} E2_DtFltDlgData;

//these need to be in same order as the date options in the config dialog
gchar *date_format [5] =
{
	"%d/%m/%Y",	//default
	"%d/%m/%Y",	//standard
	"%m/%d/%Y",	//american
	"%Y-%m-%d", //ISO
	"%x"	//localised
};

/*static void _e2_date_filter_dialog_item_toggle_cb (void)
{
	gulong handler = g_signal_handler_find (menu_item, G_SIGNAL_MATCH_FUNC,
		0, 0, NULL, e2_date_filter_dialog_create_cb, NULL);
	g_signal_handler_block (menu_item, handler);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (menu_item), !itemstate);
	g_signal_handler_unblock (menu_item, handler);
}
*/
static void _e2_date_filter_dialog_ok (E2_DtFltDlgData *data)
{
	struct tm tm_time;

	gchar *strf_withtime = g_strconcat (date_format [data->date_index] , " %T", NULL);
	gchar *date_string = g_strdup_printf ("%s 00:00:00",
	gtk_entry_get_text (GTK_ENTRY (data->date_entry)));
	strptime (date_string, strf_withtime, &tm_time);
	g_free (strf_withtime);
	g_free (date_string);
	data->view->date_filter.time = (time_t) mktime (&tm_time);

	gint index = gtk_combo_box_get_active (GTK_COMBO_BOX (data->operation_combo));
	//see below for the strings provided to the combo
	switch (index)
	{
		case ACCESSED_SINCE:
			data->view->date_filter.op = GT;
			data->view->date_filter.time_type = ATIME;
			break;
		case ACCESSED_BEFORE:
			data->view->date_filter.op = LT;
			data->view->date_filter.time_type = ATIME;
			break;
		case MODIFIED_SINCE:
			data->view->date_filter.op = GT;
			data->view->date_filter.time_type = MTIME;
			break;
		case MODIFIED_BEFORE:
			data->view->date_filter.op = LT;
			data->view->date_filter.time_type = MTIME;
			break;
		case CHANGED_SINCE:
			data->view->date_filter.op = GT;
			data->view->date_filter.time_type = CTIME;
			break;
		case CHANGED_BEFORE:
			data->view->date_filter.op = LT;
			data->view->date_filter.time_type = CTIME;
			break;
		default:
			break;
	}

	//  if (! itemstate)
	 //we're staying filtered, so re-toggle the menu item
	//	_e2_date_filter_dialog_item_toggle_cb ();
	//and conform the cached copy
	data->view->date_filter.active = TRUE;

	//show the results
	if (index > -1)
	{
		e2_toolbar_toggle_filter_button (data->view);
		e2_fileview_refilter_list (data->view);
	}
}
/**
@brief dialog response callback

@param dialog the permissions-dialog
@param response the response for the clicked button
@param data pointer to dialog data struct

@return
*/
static void _e2_date_filter_dialog_response_cb (GtkDialog *dialog,
	gint response, E2_DtFltDlgData *data)
{
	switch (response)
	{
		case GTK_RESPONSE_OK:
			gtk_widget_hide (data->dialog);
			_e2_date_filter_dialog_ok (data);
		  	//prevent toggle when dialog is destroyed
//			blocked = TRUE;
			break;
		case E2_RESPONSE_REMOVE:
			//update the cached copy of the state
			data->view->date_filter.active = FALSE;
			gtk_widget_hide (data->dialog);
			//show the results
			e2_toolbar_toggle_filter_button (data->view);
			e2_fileview_refilter_list (data->view);
			//prevent toggle when dialog is destroyed
//			blocked = TRUE;
			break;
//		case GTK_RESPONSE_CANCEL:
		default:
			//the menu item will be re-toggled when dialog is destroyed ??
			break;
	}
	gtk_widget_destroy (data->dialog);
	DEALLOCATE (E2_DtFltDlgData, data);
//	gtk_main_quit ();
}
/**
@brief handle activation (<Return> keypresses) in the query entry

@param entry UNUSED the entry widget for the combo box
@param data pointer to dialog data struct
@return
*/
static void _e2_date_filter_dialog_activated_cb (GtkEntry *entry,
	E2_DtFltDlgData *data)
{
	_e2_date_filter_dialog_response_cb (GTK_DIALOG (data->dialog),
		GTK_RESPONSE_OK, data);
}
/**
@brief create file date filter dialog

The state of @a item when it arrives here is opposite to that
shown in the menu, when clicked

@param item the clicked checkbox widget in the fillters menu
@param view data structure for the view to which the file list belongs

@return
*/
void e2_date_filter_dialog_create_cb (GtkWidget *item, ViewInfo *view)
{
	GtkWidget *hbox;
	gchar date_string[16];
	gchar *utf;
	struct tm *tm_ptr;
	gint index;
	E2_DtFltDlgData *data = ALLOCATE (E2_DtFltDlgData);
	CHECKALLOCATEDWARN (data, return;);
	data->view = view;

	//save local copies, for later use in other functions
//	data->menu_item = item;
//	data->itemstate = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM (item));

	data->dialog = e2_dialog_create (NULL, _("Display only the items:"),
		_("date filter"), _e2_date_filter_dialog_response_cb, data);
	hbox = add_hbox (GTK_DIALOG (data->dialog)->vbox, FALSE, E2_PADDING, TRUE, E2_PADDING);

	data->operation_combo = e2_combobox_add (hbox, FALSE, 0, NULL, NULL, NULL,
		E2_COMBOBOX_MENU_STYLE);
	//don't change the order of these - index value is used below and in callback
	gchar *date_choices [MAXDATECHOICES] = {
		_("modified since"), _("modified before"), _("accessed since"),
		_("accessed before"), _("changed since"), _("changed before") };
	e2_combobox_append_history_counted (data->operation_combo, MAXDATECHOICES,
		date_choices);
	switch (view->date_filter.time_type)
	{
		case MTIME:
		  index = (view->date_filter.op == GT) ? MODIFIED_SINCE : MODIFIED_BEFORE;	//0 = 1st combo string
		  break;
		case ATIME:
		  index = (view->date_filter.op == GT) ? ACCESSED_SINCE : ACCESSED_BEFORE;
		  break;
		case CTIME:
		  index = (view->date_filter.op == GT) ? CHANGED_SINCE : CHANGED_BEFORE;
		  break;
		default:
		  index = MODIFIED_SINCE;
		  break;
	}
	gtk_combo_box_set_active (GTK_COMBO_BOX (data->operation_combo), index) ;

	//get which date format to use
	data->date_index = e2_option_int_get ("date-string");
	if (data->date_index > 4)
		data->date_index = 0;	//out of range, use default format (should never happen)

	tm_ptr = localtime (&(view->date_filter.time));
	strftime (date_string, sizeof (date_string), date_format[data->date_index], tm_ptr);
	utf = e2_utf8_from_locale (date_string);
	data->date_entry = add_entry (hbox, utf, FALSE, 0);
	g_free (utf);
	gtk_widget_set_size_request (data->date_entry, 120, 30);
	//handle <Return> key-presses when the entry is focused
	g_signal_connect (G_OBJECT (data->date_entry), "activate",
		G_CALLBACK (_e2_date_filter_dialog_activated_cb), data);

	//now the buttons
//  if (!data->itemstate)
	if (!gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM (item)))
		//user has just toggled off
		e2_dialog_add_defined_button (data->dialog, &E2_BUTTON_REMOVE);
	e2_dialog_show (data->dialog, app.main_window, 0,
		&E2_BUTTON_CANCEL, &E2_BUTTON_OK, NULL);
//  gtk_main ();
}
