/*
	                   Endeavour File Browser
 */

#ifndef BROWSER_H
#define BROWSER_H

#include <gtk/gtk.h>
#include "cfg.h"
#include "toolbar.h"
#include "edv_types.h"
#include "edv_mime_type.h"
#include "edv_mount_bar.h"
#include "edv_find_bar.h"
#include "edv_status_bar.h"


typedef struct _edv_browser_struct	edv_browser_struct;
#define EDV_BROWSER(p)			((edv_browser_struct *)(p))

typedef struct _edv_browser_opid_struct	edv_browser_opid_struct;
#define EDV_BROWSER_OPID(p)		((edv_browser_opid_struct *)(p))

typedef struct _edv_browser_cmd_struct	edv_browser_cmd_struct;
#define EDV_BROWSER_CMD(p)		((edv_browser_cmd_struct *)(p))
#define EDV_BROWSER_CMD_DATA_KEY	"EDV/BROWSER/CMD"


/*
 *	File Browser Contents List Column Types:
 */
typedef enum {
	EDV_BROWSER_COLUMN_TYPE_NAME		= 0,
	EDV_BROWSER_COLUMN_TYPE_SIZE		= 1,
	EDV_BROWSER_COLUMN_TYPE_TYPE		= 2,
	EDV_BROWSER_COLUMN_TYPE_PERMISSIONS	= 3,
	EDV_BROWSER_COLUMN_TYPE_OWNER		= 4,
	EDV_BROWSER_COLUMN_TYPE_GROUP		= 5,
	EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS	= 6,
	EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED	= 7,
	EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED	= 8,
	EDV_BROWSER_COLUMN_TYPE_HARD_LINKS	= 9,
	EDV_BROWSER_COLUMN_TYPE_LINKED_TO	= 10,
	EDV_BROWSER_COLUMN_TYPE_DEVICE_INDEX	= 11,
	EDV_BROWSER_COLUMN_TYPE_INDEX		= 12,
	EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE	= 13,
	EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE	= 14,
	EDV_BROWSER_COLUMN_TYPE_BLOCKS		= 15
} edv_browser_column_type;
/* Total number of column types */
#define EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX	16


/*
 *	File Browser Column List Cell Styles:
 *
 *	Cell Style value corresponds to the index of the cell_style
 *	on the edv_browser_struct.
 */
typedef enum {
	EDV_BROWSER_CELL_STYLE_UNKNOWN,
	EDV_BROWSER_CELL_STYLE_ERROR,
	EDV_BROWSER_CELL_STYLE_NO_ACCESS,
	EDV_BROWSER_CELL_STYLE_DANGLING_LINK,
	EDV_BROWSER_CELL_STYLE_RECURSIVE_LINK,
	EDV_BROWSER_CELL_STYLE_HIDDEN,
	EDV_BROWSER_CELL_STYLE_EXECUTABLE
} edv_browser_cell_style;
/* Total number of cell styles */
#define EDV_BROWSER_TOTAL_CELL_STYLES		7


/*
 *	File Browser Command:
 */
struct _edv_browser_cmd_struct {

	edv_browser_struct	*browser;
	gchar		*label,
			*command,
			*description,
			*ext_data;
};


/*
 *	File Browser Operations:
 */
typedef enum {

	EDV_BROWSER_OP_NONE			= 0,
	EDV_BROWSER_OP_SEPARATOR		= 100,

	EDV_BROWSER_OP_CLOSE			= 200,
	EDV_BROWSER_OP_EXIT			= 201,

	EDV_BROWSER_OP_SYNC_DISKS		= 301,
	EDV_BROWSER_OP_HISTORY			= 302,
	EDV_BROWSER_OP_RUN			= 303,
	EDV_BROWSER_OP_RUN_TERMINAL		= 304,
	EDV_BROWSER_OP_WRITE_PROTECT    	= 305,
	EDV_BROWSER_OP_DELETE_METHOD_RECYCLE	= 308,
	EDV_BROWSER_OP_DELETE_METHOD_PURGE	= 309,

	EDV_BROWSER_OP_NEW			= 400,
	EDV_BROWSER_OP_NEW_FILE			= 410,
	EDV_BROWSER_OP_NEW_DIRECTORY		= 412,
	EDV_BROWSER_OP_NEW_LINK			= 413,
	EDV_BROWSER_OP_NEW_FIFO			= 414,
	EDV_BROWSER_OP_NEW_DEVICE_BLOCK		= 415,
	EDV_BROWSER_OP_NEW_DEVICE_CHARACTER	= 416,
	EDV_BROWSER_OP_NEW_SOCKET		= 417,

	EDV_BROWSER_OP_OPEN			= 500,
	EDV_BROWSER_OP_OPEN_TO			= 501,
	EDV_BROWSER_OP_OPEN_WITH		= 502,

	EDV_BROWSER_OP_COPY_PATH		= 601,
	EDV_BROWSER_OP_COPY_URL			= 602,
	EDV_BROWSER_OP_PASTE			= 610,

	EDV_BROWSER_OP_MOVE			= 700,
	EDV_BROWSER_OP_COPY			= 701,
	EDV_BROWSER_OP_LINK			= 702,
	EDV_BROWSER_OP_RENAME			= 703,
	EDV_BROWSER_OP_CHMOD			= 704,
	EDV_BROWSER_OP_CHOWN			= 705,
	EDV_BROWSER_OP_CHTIME			= 706,
	EDV_BROWSER_OP_DELETE			= 770,
	EDV_BROWSER_OP_PROPERTIES		= 780,

	EDV_BROWSER_OP_SELECT_ALL		= 800,
	EDV_BROWSER_OP_UNSELECT_ALL		= 801,
	EDV_BROWSER_OP_INVERT_SELECTION		= 802,
	EDV_BROWSER_OP_FIND			= 850,

	EDV_BROWSER_OP_DOWNLOAD			= 900,

	EDV_BROWSER_OP_REFRESH			= 1000,
	EDV_BROWSER_OP_REFRESH_ALL		= 1001,
	EDV_BROWSER_OP_GOTO_PARENT		= 1100,
	EDV_BROWSER_OP_GOTO_HOME		= 1101,
	EDV_BROWSER_OP_EXPAND			= 1200,

	EDV_BROWSER_OP_SHOW_TOOL_BAR		= 1300,
	EDV_BROWSER_OP_SHOW_LOCATION_BAR	= 1301,
	EDV_BROWSER_OP_SHOW_MOUNT_BAR		= 1302,
	EDV_BROWSER_OP_SHOW_FIND_BAR		= 1303,
	EDV_BROWSER_OP_SHOW_STATUS_BAR		= 1304,

	EDV_BROWSER_OP_CONTENTS_LIST_FILTER	= 1400,
	EDV_BROWSER_OP_CONTENTS_LIST_AUTO_RESIZE_COLUMNS = 1410,
	EDV_BROWSER_OP_SHOW_HIDDEN_OBJECTS	= 1420,
	EDV_BROWSER_OP_SHOW_NOACCESS_OBJECTS	= 1421,

	EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN	= 1500,

	EDV_BROWSER_OP_MOUNT                    = 1600,	/* Mount/unmount */
	EDV_BROWSER_OP_EJECT                    = 1620,
	EDV_BROWSER_OP_DEVICE_CHECK             = 1650,
	EDV_BROWSER_OP_DEVICE_TOOLS             = 1651,
	EDV_BROWSER_OP_DEVICE_FORMAT            = 1652,

	EDV_BROWSER_OP_MIME_TYPES		= 1700,
	EDV_BROWSER_OP_DEVICES			= 1701,

	EDV_BROWSER_OP_NEW_BROWSER		= 1800,
	EDV_BROWSER_OP_NEW_IMBR			= 1801,
	EDV_BROWSER_OP_NEW_ARCHIVER		= 1802,
	EDV_BROWSER_OP_RECYCLE_BIN		= 1900,

	EDV_BROWSER_OP_OPTIONS			= 2000,
	EDV_BROWSER_OP_CUSTOMIZE		= 2001,

	EDV_BROWSER_OP_HELP_CONTENTS		= 3000,
	EDV_BROWSER_OP_HELP_FILE_BROWSER	= 3010,
	EDV_BROWSER_OP_HELP_IMAGE_BROWSER	= 3011,
	EDV_BROWSER_OP_HELP_ARCHIVER		= 3012,
	EDV_BROWSER_OP_HELP_RECYCLE_BIN		= 3030,
	EDV_BROWSER_OP_HELP_KEYS_LIST		= 3050,
	EDV_BROWSER_OP_HELP_MIME_TYPES		= 3051,
	EDV_BROWSER_OP_HELP_DEVICES		= 3052,
	EDV_BROWSER_OP_HELP_COMMON_OPERATIONS	= 3053,
	EDV_BROWSER_OP_HELP_ABOUT		= 3100

} edv_browser_op;


/*
 *	File Browser Operation ID:
 */
struct _edv_browser_opid_struct {

	edv_browser_op	op;
	edv_opid_flags	flags;
	toolbar_item_type tb_item_type;
	edv_browser_struct	*browser;

	/* Operation callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	/* Enter and leave notify callbacks */
	void	(*enter_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);
	void	(*leave_func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* OPID */
	);

	gchar	*button_name,	/* Name as it would appear on a button */
		*menu_name,	/* Name as it would appear on a menu item */
		*tooltip;	/* Tool tip or description (one line) */

	guint	accel_key,	/* Accelerator key */
		accel_mods;	/* Accelerator key modifiers */

	guint8	**button_icon_data,	/* Shared */
		**menu_icon_data;	/* Shared */

};


/*
 *	File Browser:
 */
struct _edv_browser_struct {

	GtkWidget	*toplevel;
	gboolean	processing;
	gint		freeze_count,
			busy_count;
	edv_core_struct	*core;

	GList		*opid_list;

	gboolean	tool_bar_map_state,
			location_bar_map_state,
			mount_bar_map_state,
			find_bar_map_state,
			status_bar_map_state;

	GtkWidget	*main_vbox,
			*menu_bar,
			*bars_vbox,		/* Toolbars GtkVBox */

			*menu_bar_handle,
			*tool_bar_handle,
			*location_bar_handle,
			*mount_bar_handle,
			*find_bar_handle,

			*location_bar_hbox,	/* GtkHBox parent for location bar */
			*location_icon_fixed,
			*location_icon_pm,
			*location_combo,

			*main_paned,		/* GtkHPaned */
			*directory_ctree,	/* Directory GtkCTree */
			*contents_clist;	/* Contents GtkCList */

	guint		directory_ctree_expand_optimize_idleid;

	/* Tool Bar */
	toolbar_struct	*tool_bar;

	/* Mount Bar */
	edv_mount_bar_struct	*mount_bar;

	/* Find Bar */
	edv_find_bar_struct	*find_bar;

	/* Menus and Menu Items */
	GtkWidget	*file_menu,
			*open_mi,
			*open_to_mi,
			*open_to_menu,
			*open_with_mi,
			*new_object_mi,
			*new_object_menu,
			*new_file_mi,
			*new_directory_mi,
			*new_link_mi,
			*new_fifo_mi,
			*new_device_block_mi,
			*new_device_character_mi,
			*new_socket_mi,
			*sync_disks_mi,
			*history_mi,
			*run_mi,
			*close_mi,

			*edit_menu,
			*move_mi,
			*copy_mi,
			*link_mi,
			*rename_mi,
			*chmod_mi,
			*chown_mi,
			*chtime_mi,
			*delete_mi,
			*copy_path_mi,
			*copy_url_mi,
			*paste_mi,
			*select_all_mi,
			*unselect_all_mi,
			*invert_selection_mi,
			*find_mi,
			*properties_mi,

			*view_menu,
			*refresh_mi,
			*refresh_all_mi,
			*show_tool_bar_micheck,
			*show_location_bar_micheck,
			*show_mount_bar_micheck,
			*show_find_bar_micheck,
			*show_status_bar_micheck,
			*directory_tree_origin_mi,
			*show_hidden_objects_micheck,
			*show_noaccess_objects_micheck,
			*contents_list_filter_mi,
			*contents_list_auto_resize_columns_micheck,
			*mime_types_mi,

			*device_menu,
			*mount_mi,
			*eject_mi,
			*device_check_mi,
			*device_tools_mi,
			*device_format_mi,
			*devices_mi,

			*settings_menu,
			*write_protect_mi,
			*delete_method_recycle_micheck,
			*delete_method_purge_micheck,
			*options_mi,
			*customize_mi,

			*windows_menu,
			*window_new_browser_mi,
			*window_new_imbr_mi,
			*window_new_archiver_mi,
			*window_recycle_bin_mi,

			*help_menu,
			*help_contents_mi,
			*help_file_browser_mi,
			*help_keys_list_mi,
			*help_mime_types_mi,
			*help_devices_mi,
			*help_common_operations_mi,
			*help_about_mi;


	/* Directory Tree right-click menu */
	GtkWidget	*directory_ctree_menu,
			*directory_ctree_expand_mi,	/* Expand or colapse */
			*directory_ctree_mount_mi,
			*directory_ctree_eject_mi,
			*directory_ctree_mount_misep,
			*directory_ctree_move_mi,
			*directory_ctree_copy_mi,
			*directory_ctree_link_mi,
			*directory_ctree_rename_mi,
			*directory_ctree_chmod_mi,
			*directory_ctree_chown_mi,
			*directory_ctree_chtime_mi,
			*directory_ctree_delete_mi,
			*directory_ctree_copy_path_mi,
			*directory_ctree_copy_url_mi,
			*directory_ctree_paste_mi,
			*directory_ctree_properties_mi;

	/* Contents List right-click menu */
	GtkWidget       *contents_clist_menu,
			*contents_clist_open_mi,
			*contents_clist_open_to_mi,
			*contents_clist_open_to_menu,
			*contents_clist_open_with_mi,
			*contents_clist_move_mi,
			*contents_clist_copy_mi,
			*contents_clist_link_mi,
			*contents_clist_rename_mi,
			*contents_clist_chmod_mi,
			*contents_clist_chown_mi,
			*contents_clist_chtime_mi,
			*contents_clist_delete_mi,
			*contents_clist_copy_path_mi,
			*contents_clist_copy_url_mi,
			*contents_clist_paste_mi,
			*contents_clist_properties_mi;


	/* Contents list filter */
	gchar		*contents_list_filter;


	/* Styles for the Directory Tree & Contents List cells */
	GtkStyle	*cell_style[EDV_BROWSER_TOTAL_CELL_STYLES];

	/* Special icons */
	GdkPixmap	*folder_parent_pixmap;
	GdkBitmap	*folder_parent_mask;

	/* Directory toplevel origin directory */
	gchar		*directory_ctree_origin_path;

	/* Last selected node on the ctree (can be NULL)
	 * Note that even if this value is not NULL it should still
	 * be verified that it is a valid node that actuall exists on
	 * the ctree
	 */
	GtkCTreeNode	*directory_ctree_selected_node;

	/* Selected device, reflects the device of the disk object of
	 * the node specified by directory_ctree_selected_node
	 *
	 * This device number corresponds with a device on the core's
	 * list of devices
	 */
	gint		selected_dev_num;

	/* Last selected row on the clist (can be -1 for none)
	 *
	 * Note that this does not reflect other selected rows since
	 * multiple selections are allowed
	 */
	gint		contents_clist_selected_row;


	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 *
	 * Can be -1 to indicate undefined
	 */
	gint		last_recbin_items;

	/* Last known write protect state (can be -1 to indicate
	 * undefined)
	 */
	gint		last_write_protect_state;


	/* Status Bar */
	edv_status_bar_struct	*status_bar;

};


/* Utilities */
extern edv_browser_opid_struct *EDVBrowserMatchOPID(
	edv_browser_struct *browser,
	const edv_browser_op op
);
extern gboolean EDVBrowserIsPathFromDirTreeOrigin(
	edv_browser_struct *browser,
	const gchar *path
);

/* Title */
extern void EDVBrowserSetTitle(
	edv_browser_struct *browser,
	const gchar *path
);

/* Location */
extern const gchar *EDVBrowserCurrentLocation(edv_browser_struct *browser);
extern void EDVBrowserSetLocation(
	edv_browser_struct *browser,
	const gchar *path,
	const gboolean record_history
);
extern void EDVBrowserUpdateLocationIcon(
	edv_browser_struct *browser,
	const gchar *path
);

/* Selected Objects & Paths */
extern GList *EDVBrowserGetSelectedObjectsList(
	edv_browser_struct *browser,
	const gboolean copy
);
extern GList *EDVBrowserGetSelectedPathsList(edv_browser_struct *browser);

/* Regenerating Menus, Bars, etc */
extern void EDVBrowserAccelkeysRegenerate(edv_browser_struct *browser);
extern void EDVBrowserListStylesRegenerate(edv_browser_struct *browser);
extern void EDVBrowserToolBarRegenerate(edv_browser_struct *browser);
extern void EDVBrowserFileMenuItemsRegenerate(edv_browser_struct *browser);
extern void EDVBrowserNewObjectMenuItemsRegenerate(edv_browser_struct *browser);
extern void EDVBrowserOpenToMenuRegenerate(
	edv_browser_struct *browser,
	edv_mime_type_struct *m
);
extern void EDVBrowserDirectoryMenuRegenerate(edv_browser_struct *browser);
extern void EDVBrowserContentsMenuRegenerate(edv_browser_struct *browser);

/* Sync Configuration */
extern void EDVBrowserSyncConfiguration(edv_browser_struct *browser);

/* Operation IDs */
extern GList *EDVBrowserOPIDListNew(edv_browser_struct *browser);
extern void EDVBrowserOPIDListDelete(GList *glist);

/* Accelkeys */
extern cfg_accelkey_list_struct *EDVBrowserAccelkeysListNewDefault(void);

/* File Browser */
extern edv_browser_struct *EDVBrowserNew(edv_core_struct *core);
extern void EDVBrowserSyncData(edv_browser_struct *browser);
extern void EDVBrowserUpdateMenus(edv_browser_struct *browser);
extern void EDVBrowserSetBusy(edv_browser_struct *browser, const gboolean busy);
extern gboolean EDVBrowserIsMapped(edv_browser_struct *browser);
extern void EDVBrowserMap(edv_browser_struct *browser);
extern void EDVBrowserUnmap(edv_browser_struct *browser);
extern void EDVBrowserDelete(edv_browser_struct *browser);


#endif	/* BROWSER_H */
