#ifndef EDV_ARCHIVE_ADD_H
#define EDV_ARCHIVE_ADD_H

#include <gtk/gtk.h>
#include "edv_types.h"


/* Error Messages */
extern const gchar *EDVArchAddGetError(edv_core_struct *core);
extern void EDVArchAddCopyErrorMessage(
	edv_core_struct *core, const gchar *msg
);

/* Progress Dialog */
extern void EDVArchAddMapProgressDialog(
	const gchar *label, const gfloat progress,
	GtkWidget *toplevel, const gboolean force_remap
);
extern void EDVArchAddMapProgressDialogUnknown(
	const gchar *label, GtkWidget *toplevel,
	const gboolean force_remap
);

/* Calculate Total Size */
extern gulong EDVArchAddCalculateTotalSize(
	const gchar *arch_path, const gchar *path,
	gint *nobjs,
	const gboolean recursive, const gboolean dereference_links
);

/* Add To Archive */
extern gint EDVArchAdd(
	edv_core_struct *core,
	const gchar *arch_path,
	GList *tar_paths_list,			/* List of gchar * paths */
	GList **new_paths_list_rtn,		/* Return list of gchar * paths */
	const gchar *password,
	GtkWidget *toplevel,
	const gboolean show_progress, const gboolean interactive,
	gboolean *yes_to_all,
	const gboolean recursive, const gint compression,
	const gboolean dereference_links
);


#endif	/* EDV_ARCHIVE_ADD_H */
