#ifndef __ENODE_H__
#define __ENODE_H__

#include <ebuffer.h>


typedef enum {
    ENODE_RENDERED = 1 << 0,
    ENODE_PARENTED = 1 << 1,
    ENODE_DELETED = 1 << 2,
    ENODE_NO_RENDER_CHILDREN = 1 << 3,
    /* These are used to keep state in the parser which requires these per
     * node */
    ENODE_HAS_CDATA = 1 << 4,
    ENODE_IN_CDATA_SECTION = 1 << 5,
    ENODE_INSTANCE_PLACEHOLDER = 1 << 6
} ENodeFlags;

#define ENODE_FLAGS(node) 		(node->flags)
#define ENODE_SET_FLAG(node,flag)	G_STMT_START{ (ENODE_FLAGS (node) |= (flag)); }G_STMT_END
#define ENODE_UNSET_FLAG(node,flag)	G_STMT_START{ (ENODE_FLAGS (node) &= ~(flag)); }G_STMT_END
#define ENODE_FLAG_ISSET(node,flag)	((ENODE_FLAGS (node) & flag) != 0)

typedef struct _ENode ENode;

struct _ENode {
    /* List of child nodes, keep tail pointer arround for fast appends */
    GSList *children;
    GSList *children_tail;

    /* A list of the above eventwatcher structs for keeping track of event
     * watchers */
    GSList *event_watchers;

    /* parent node. */
    ENode *parent;

    /* This node's tag */
    EBuf *element;

    /* Data associated with tag */
    EBuf *data;

    /* XML attr/value pairs */
    GSList *attribs;
    GSList *attribs_tail;

    /* This will contain any information needed for passing to child nodes
     * for rendering modules. eg. this holds the GtkWidget * for tags that
     * deal with widgets. Use enode_set_kv() and enode_get_kv() for
     * interface, */
    GHashTable *entity_data;

    /* For internal use to keep track of state. */
    gint32 flags;

    /* For refcounting */
    gint refcount;
};

#include "enode-attribs.h"
#include "enode-base.h"
#include "enode-call.h"
#include "enode-data.h"
#include "enode-destroy.h"
#include "enode-kv.h"
#include "enode-search.h"
#include "enode-xml.h"
#include "enode-event.h"
#include "enode-treewalk.h"

#endif				/* __ENODE_H__ */


