#ifndef __RARGV_H__
#define __RARGV_H__


/* This little macro makes a simple argument parser for your program.  It
 * assumes that arguments to main are given in the standard format:
 *
 * int main (int argc, char **argv)
 *
 * and will not work otherwise.
 *
 * RARGV_SWITCH sets up a switch which will switch off of any argument
 * character (eg, -h, -v etc.).  Any unknown string which it does not
 * perceive to be an option, will show up as a '*', which you can
 * check for in your switch statement (or let it fall through as the
 * default).
 *
 * Note there is a difference between what will show up in your 'default'
 * and what '*' catches.  If you have both, '*' will catch arguments
 * that don't start with a -, or are only a '-', whereas the default 
 * case will only catch flags not previously handled.  After a '--'
 * sequence on the command line (which you will not see in the argument
 * switching), all arguments thereafter will show up under the '*' case.
 *
 * RARGV_CURRENT returns the current argument string that you are
 * working with.
 *
 * RARGV_NEXT returns the next argument (or NULL if there are no more
 * arguments), and advances the system to the next argument.
 *
 * RARGV_CURRENT_FLAG is the current char being switched on.
 *
 * RARGV_CLOSE is used to close off the switch statement.
 *
 */


#define RARGV_SWITCH \
    do { \
        char roy_arg; \
        int roy_curarg; \
        int roy_subarg; \
        int roy_arglen; \
        int roy_escape = FALSE; \
        \
        for (roy_curarg = 1; roy_curarg < argc; roy_curarg++) { \
            if (argv[roy_curarg][0] == '-' && argv[roy_curarg][1] == '-' && \
                argv[roy_curarg][2] == '\0' && roy_escape == FALSE) { \
                roy_escape = TRUE; \
                roy_arglen = 0; \
                roy_arg = '*'; /* silence compiler */ \
            } else if (argv[roy_curarg][0] != '-' || argv[roy_curarg][1] == '\0' || roy_escape) { \
                roy_arg = '*'; \
                roy_arglen = 2; \
            } else { \
                roy_arg = argv[roy_curarg][1]; \
                for (roy_arglen = 0; argv[roy_curarg][roy_arglen]; roy_arglen++); \
            } \
            for (roy_subarg = 1; roy_subarg < roy_arglen; roy_subarg++, roy_arg = argv[roy_curarg][roy_subarg]) \
                switch (roy_arg)


#define RARGV_CURRENT (argv[roy_curarg])
                
#define RARGV_NEXT (roy_subarg == roy_arglen - 1 ? ++roy_curarg > argc ? NULL : argv[roy_curarg] : NULL)

#define RARGV_CURRENT_FLAG (roy_arg)

#define RARGV_CLOSE } } while (0)

#endif /* __RARGV_H__ */


