#include <entity.h>
#include <cschtml/cschtml.h>
#include "../gtk/gtk-common.h"


static void
rendcschtml_set_data (ENode * node, EBuf * data)
{
    CscHTML *cschtml;
    CscHTMLStream *handle;


    cschtml = CSC_HTML (enode_get_kv (node, "html-widget"));

    EDEBUG (("cschtml", "inserting %s", data->str));

    handle = csc_html_begin (cschtml);
    csc_html_write (cschtml, handle, data->str, data->len);
    csc_html_end (cschtml, handle, CSC_HTML_STREAM_OK);
}

static void
rendcschtml_parent (ENode * parent_node, ENode * child_node)
{
    erend_short_curcuit_parent (parent_node, child_node);
}

static void
rendcschtml_destroy (ENode * node)
{
    GtkWidget *html;

    html = enode_get_kv (node, "html-widget");
    gtk_widget_destroy (html);
}

/* The html widget goes nuts if you don't put it in a scrollwindow. */
static void
rendcschtml_render (ENode * node)
{
    GtkWidget *scrollwindow;
    GtkWidget *html;
    CscHTML *cschtml;
    CscHTMLStream *handle;

    EDEBUG (("cschtml", "creating new cschtml"));

    scrollwindow = gtk_scrolled_window_new (NULL, NULL);
    html = csc_html_new ();
    cschtml = CSC_HTML (html);

    enode_set_kv (node, "html-widget", html);
    enode_set_kv (node, "top-widget", scrollwindow);

    EDEBUG (("cschtml", "starting with %s", node->data->str));

    handle = csc_html_begin (cschtml);
    csc_html_write (cschtml, handle, node->data->str, node->data->len);
    csc_html_end (cschtml, handle, CSC_HTML_STREAM_OK);

    gtk_container_add (GTK_CONTAINER (scrollwindow), html);

    enode_attribs_sync (node);
    rendgtk_show_cond (node, scrollwindow);
    rendgtk_show_cond (node, html);
}

void
renderer_init (RendererFlags flags)
{
    Element *element;
    ElementAttr *e_attr;

    EDEBUG (("cschtml", "registering cschtml"));

    if (flags & RENDERER_REGISTER)
    {
	EDEBUG (("cschtml", "Registering <cschtml> element"));
	element = g_new0 (Element, 1);
	element->render_func = rendcschtml_render;
	element->parent_func = rendcschtml_parent;
	element->destroy_func = rendcschtml_destroy;
	element->set_data_func = rendcschtml_set_data;
	element->tag = "cschtml";
	element_register (element);

	/* For now we don't register any attributes. */
    }
}

