#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static void
 rendgtk_list_item_onselect_callback (GtkWidget * widget, gpointer user_data);
static void
 rendgtk_list_item_ondeselect_callback (GtkWidget * widget, gpointer user_data);


static gint
rendgtk_list_item_selected_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *item;

    item = enode_get_kv (node, "top-widget");
    if (!item)
      	return FALSE;

    gtk_list_item_select (GTK_LIST_ITEM (item));
    return TRUE;
}

static gint
rendgtk_list_selection_style_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *list;

    list = enode_get_kv (node, "top-widget");

    if (!list)
	return FALSE;

    /* GTK_SELECTION_SINGLE, GTK_SELECTION_BROWSE, GTK_SELECTION_MULTIPLE,
     * GTK_SELECTION_EXTENDED */

    EDEBUG (("list-renderer", "selection type set to %s", value));

    if (ebuf_equal_str (value, "multiple")) {
	gtk_list_set_selection_mode (GTK_LIST (list), GTK_SELECTION_MULTIPLE);
	return (TRUE);
    }

    if (ebuf_equal_str (value, "browse")) {
	gtk_list_set_selection_mode (GTK_LIST (list), GTK_SELECTION_BROWSE);
	return (TRUE);
    }

    if (ebuf_equal_str (value, "extended")) {
	gtk_list_set_selection_mode (GTK_LIST (list), GTK_SELECTION_EXTENDED);
	return (TRUE);
    }

    gtk_list_set_selection_mode (GTK_LIST (list), GTK_SELECTION_SINGLE);

    return (TRUE);
}

static void
rendgtk_list_item_render (ENode * node)
{
    ENode *list_node;
    GtkWidget *hbox;			/* Our bottom-widget. */
    GtkWidget *item;			/* Our top-widget. */

    list_node = enode_parent (node, "list");
    if (!list_node)
      return;

    EDEBUG (("list-renderer", "building new list-item."));
    item = gtk_list_item_new ();

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (item), hbox);

    enode_set_kv (node, "top-widget", item);
    enode_set_kv (node, "bottom-widget", hbox);

    gtk_widget_show (hbox);
    enode_attribs_sync (node);
    rendgtk_show_cond (node, item);
}


static void
rendgtk_list_render (ENode * node)
{
    GtkWidget *list;

    list = gtk_list_new ();

    enode_set_kv (node, "top-widget", list);
    enode_set_kv (node, "bottom-widget", list);

    enode_attribs_sync (node);
    rendgtk_show_cond (node, list);
}


static void rendgtk_list_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *item;
    GtkWidget *list;
    GList *new_items = NULL;	/* A list of items to sate the bad API gods. */

    list = enode_get_kv (parent_node, "top-widget");
    if (!list)
      return;

    item = enode_get_kv (child_node, "top-widget");
    if (!item)
      return;

    if (! ebuf_equal_str (child_node->element, "list-item") ) {
        g_warning ("Only list-item elements can be in lists.");
	return;
    }

    EDEBUG (("list-renderer", "adding list-item to list."));

    new_items = g_list_append (new_items, item);

    gtk_list_append_items ( (GtkList *) list, new_items);

    gtk_signal_connect (GTK_OBJECT (item), "select",
			rendgtk_list_item_onselect_callback, child_node);
    gtk_signal_connect (GTK_OBJECT (item), "deselect",
			rendgtk_list_item_ondeselect_callback, child_node);
}


static void
rendgtk_list_item_onselect_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    ENode *parent_node;
    gchar *function = NULL;

    enode_attrib_quiet (node, "selected", ebuf_new_with_true ());

    function = enode_attrib_str (node, "onselect", NULL);

    /* If this doesn't implement the onselect function, check if parent does */
    if (!function) {
	parent_node = enode_parent (node, "list");
	if (parent_node)
	    function = enode_attrib_str (parent_node, "onselect", NULL);
    }

    if (function)
	enode_call_ignore_return (node, function, "");
}


static void
rendgtk_list_item_ondeselect_callback (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    ENode *parent_node;
    gchar *function = NULL;

    enode_attrib_quiet (node, "selected", ebuf_new_with_str (""));

    function = enode_attrib_str (node, "ondeselect", NULL);

    /* If this doesn't implement the onselect function, check if parent does */
    if (!function) {
	parent_node = enode_parent (node, "list");
	if (parent_node)
	    function = enode_attrib_str (parent_node, "ondeselect", NULL);
    }

    if (function)
	enode_call_ignore_return (node, function, "");
}

void
list_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    /* List */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_list_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_list_parent;
    element->tag = "list";
    element->description = "Create a new list widget.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_LIST);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "selection-style";
    e_attr->description = "The mode of the selection.";
    e_attr->value_desc = "choice";
    e_attr->possible_values = "single,multiple,browse,extended";
    e_attr->set_attr_func = rendgtk_list_selection_style_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description =
	"Specify function to call when a sub item is 'selected'.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(selected_node)";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "ondeselect";
    e_attr->description =
	"Specify function to call when a sub item is 'deselected'.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(deselected_node)";
    e_attr->set_attr_func = NULL;
    element_register_attrib (element, e_attr);


    /* List Item */

    element = g_new0 (Element, 1);
    element->tag = "list-item";
    element->description = "Create an item for in a list.";
    element->render_func = rendgtk_list_item_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element_register (element);
    rendgtk_containerbox_attr_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_LIST_ITEM);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description = "Function to call when a list-item is clicked";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(selected_node)";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "ondeselect";
    e_attr->description = "Function to call when a list-item is deselected";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(deselected_node, selected_column)";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "selected";
    e_attr->description = "Determine or set if this item is selected.";
    e_attr->value_desc = "boolean";
    e_attr->set_attr_func = rendgtk_list_item_selected_attr_set;
    element_register_attrib (element, e_attr);
}

