#include <stdlib.h>
#include "entity.h"
#include "SDL.h"

#include "sdl-common.h"


/**sdl_mouse_get_coords
 * Sets the mouse kv's after quering SDL.
 *
 */
static void
sdl_mouse_get_coords (ENode * node, gchar * attr)
{
  int x = -1;
  int y = -1;
  static char buf[256] = "";

  /* Query SDL for mouse information. */
  (void) SDL_GetMouseState(&x, &y);

  /* Get X. */
  snprintf (buf, 255, "%d", x);
  enode_attrib_str (node, "x", buf);

  /* Get Y. */
  snprintf (buf, 255, "%d", y);
  enode_attrib_str (node, "y", buf);

}


/**sdl_mouse_get_mouse
 * Sets the mouse kv's after quering SDL.
 *
 */
static void
sdl_mouse_get_buttons (ENode * node, gchar * attr)
{
  int x = -1;
  int y = -1;
  Uint8 button_mask;

  /* Query SDL for mouse information. */
  button_mask = SDL_GetMouseState(&x, &y);

  if (button_mask == SDL_BUTTON(1))
    {
      enode_attrib_str (node, "button1", "true");
    }
  else
    {
      enode_attrib_str (node, "button1", "false");
    }

  if (button_mask == SDL_BUTTON(2))
    {
      enode_attrib_str (node, "button2", "true");
    }
  else
    {
      enode_attrib_str (node, "button2", "false");
    }

  if (button_mask == SDL_BUTTON(3))
    {
      enode_attrib_str (node, "button3", "true");
    }
  else
    {
      enode_attrib_str (node, "button3", "false");
    }
}


/**sdl_mouse_setup
 * setup the mouse.
 */
static void
sdl_mouse_setup (ENode * node)
{
}


/**sdl_sprite_destroy
 * Free the sprite.
 */
static void
sdl_mouse_destroy (ENode * node)
{
}


/**sdl_mouse_register
 * Register the sdl mouse attributes. 
 */
void sdl_mouse_register (void)
{
  Element *element;
  ElementAttr *e_attr;

  /* Register sdl-mouse. */
  element = g_new0 (Element, 1);
  element->render_func = sdl_mouse_setup; 
  element->destroy_func = sdl_mouse_destroy;
  element->parent_func = NULL;
  element->tag = "sdl-mouse";
  element->description = "Create a new SDL window.";
  element_register (element);

  /* X position attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "x";
  e_attr->description = "X position of the mouse";
  e_attr->value_desc = "integer";
  e_attr->possible_values = "-1,*";
  e_attr->set_attr_func = NULL;
  e_attr->get_attr_func = sdl_mouse_get_coords;
  element_register_attrib (element, e_attr);

  /* Y position attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "y";
  e_attr->description = "Y position of the mouse.";
  e_attr->value_desc = "integer";
  e_attr->possible_values = "-1,*";
  e_attr->set_attr_func = NULL;
  e_attr->get_attr_func = sdl_mouse_get_coords;
  element_register_attrib (element, e_attr);

  /* Button1 attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "button1";
  e_attr->description = "Button 1 on the mouse";
  e_attr->value_desc = "boolean";
  e_attr->possible_values = "true,false";
  e_attr->set_attr_func = NULL;
  e_attr->get_attr_func = sdl_mouse_get_buttons;
  element_register_attrib (element, e_attr);

  /* Button2 attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "button2";
  e_attr->description = "Button 2 on the mouse";
  e_attr->value_desc = "boolean";
  e_attr->possible_values = "true,false";
  e_attr->set_attr_func = NULL;
  e_attr->get_attr_func = sdl_mouse_get_buttons;
  element_register_attrib (element, e_attr);

  /* Button3 attribute. */
  e_attr = g_new0 (ElementAttr, 1);
  e_attr->attribute = "button3";
  e_attr->description = "Button 3 on the mouse";
  e_attr->value_desc = "boolean";
  e_attr->possible_values = "true,false";
  e_attr->set_attr_func = NULL;
  e_attr->get_attr_func = sdl_mouse_get_buttons;
  element_register_attrib (element, e_attr);
}
