<window name="search" title="Search" border="8" visible="false" position="center" 
 ondelete="hide_search_dialog">
    <valign spacing="10">
      <halign>
        <label text="Search For:" width="85" xalign="0"/>
        <entry name="search_string" onenter="do_search" width="125"/>
      </halign>
      <halign>
        <label text="Search Type:" width="85" xalign="0" yalign="20"/>
        <valign>
          <radio-group>
            <radio selected="true">
              <label text="Basename Match" xalign="0"/>
            </radio>
            <radio name="search_regex">
              <label text="Regular Expression" xalign="0"/>
            </radio>
          </radio-group>
        </valign>
      </halign>
      <halign>
        <label text="Search From:" width="85" xalign="0" yalign="20"/>
        <valign>
          <radio-group>
            <radio name="root_node_search" selected="true" width="80">
              <label text="Root Node" xalign="0"/>
            </radio>
            <radio>
              <label text="Selected Node" xalign="0"/>
            </radio>
          </radio-group>
        </valign>
      </halign>
      <halign border="5" spacing="3">
        <halign expand="true"/>
        <button onclick="do_search" label="OK" expand="true" width="50"/>
        <button onclick="hide_search_dialog" label="Cancel" expand="true" width="50"/>
        <halign expand="true"/>
      </halign>
    </valign>
</window>


<window name="search_error" title="Node Not Found" border="10"
 position="center" visible="false" onclick="hide_window">
    <valign spacing="10">
      <label text="The node could not be found!"/>
      <halign>
        <button onclick="hide_window" arg="window.search_error" 
	 fill="false" expand="true" focus="false">
          <halign padding="1">
            <label text="OK" padding="15"/>
          </halign>
        </button>
      </halign>
    </valign>
</window>

<?javascript

function hide_search_dialog (node)
{
    window = enode("window.search");
    window.attrib.visible = "false";
}

function show_search_dialog (node)
{
    entry = enode("entry.search_string");
    entry.attrib.text = "";
    enode ("window.search").attrib.visible = "true";
}


function do_search (node)
{
    regex_selected = enode ("radio.search_regex").attrib.selected;
    root_node_search = enode ("radio.root_node_search").attrib.selected;

    if (root_node_search == "true") {
	dest_node = enode ("/");
    } else {
	cursel_node = selected_node ();
        if (cursel_node != null) {
	    dest_node = enode (cursel_node.attrib["dest-node"]);
        } else {
	    dest_node = enode ("/");
        }
    }	

    search_string = enode("entry.search_string").attrib.text;

    if (regex_selected == "true") {
	found = dest_node.child_rx (search_string);
    } else {
	found = dest_node.child (search_string);
    }

    if (found != null) {
	print ("found node", found.path);
	expand_tree_to (found);
        hide_search_dialog (node);
    } else {
	enode ("window.search_error").attrib.visible = "true";
    }
}

?>

