/* 
 * Label.h -- ePiX::Label class
 *
 * This file is part of ePiX, a preprocessor for creating high-quality 
 * line figures in LaTeX 
 *
 * Version 1.0.15
 * Last Change: October 09, 2006
 */

/* 
 * Copyright (C) 2001, 2002, 2003, 2004, 2005, 2006
 * Andrew D. Hwang <rot 13 nujnat at zngupf dot ubylpebff dot rqh>
 * Department of Mathematics and Computer Science
 * College of the Holy Cross
 * Worcester, MA, 01610-2395, USA
 */

/*
 * ePiX is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ePiX is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ePiX; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/*
 *   This file provides:
 *
 *   The Label class
 *     - location
 *     - offset
 *     - alignment option
 *     - type
 *     - text field
 *
 *     Label(posn, f(posn)) // numerical label at specified location
 *     move_to(P) // change basepoint
 *     offset(P)  // change offset
 *     align(epix_label_posn) // change alignment
 */


#ifndef EPIX_LABEL
#define EPIX_LABEL

#include "globals.h"
#include "triples.h"

namespace ePiX {

  class Label {
  public:
    Label(const P& basepoint, 
	  const std::string& label_text, 
	  epix_mark_type label_type=TEXT,
	  epix_label_posn alignment=none, 
	  bool mask=false,
	  const P& offset=P(0,0));

    Label(const P& basepoint, double f(P),
	  epix_label_posn alignment=none, 
	  bool mask=false,
	  const P& offset=P(0,0));

    Label& move_to(const P& arg);
    Label& offset(const P& arg);
    Label& align(epix_label_posn arg);

    void draw() const;

  private:
    P the_basepoint;
    std::string the_label_text;
    epix_mark_type the_label_type;
    epix_label_posn the_alignment;
    bool masked;
    P the_offset;
  }; // end of Label class

} // end of namespace

#endif /* EPIX_LABEL */
