/*
  This file is part of libkdepim.

  Copyright (c) 2004 Bram Schoenmakers <bramschoenmakers@kde.nl>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include <qdatetime.h>
#include <qpopupmenu.h>

#include <klocale.h>
#include <kcalendarsystem.h>
#include <kglobal.h>

#include "kdatepickerpopup.h"

KDatePickerPopup::KDatePickerPopup( int items, const QDate &date, QWidget *parent,
                                    const char *name )
  : QPopupMenu( parent, name )
{
  mItems = items;

  mDatePicker = new KDatePicker( this );
  mDatePicker->setCloseButton( false );

  connect( mDatePicker, SIGNAL( dateEntered( QDate ) ),
           SLOT( slotDateChanged( QDate ) ) );
  connect( mDatePicker, SIGNAL( dateSelected( QDate ) ),
           SLOT( slotDateChanged( QDate ) ) );

  mDatePicker->setDate( date );

  buildMenu();
}

void KDatePickerPopup::buildMenu()
{
  if ( isVisible() ) return;
  clear();

  if ( mItems & DatePicker ) {
    insertItem( mDatePicker );
  }

}

KDatePicker *KDatePickerPopup::datePicker() const
{
  return mDatePicker;
}

void KDatePickerPopup::setDate( const QDate &date )
{
  mDatePicker->setDate( date );
}

void KDatePickerPopup::slotDateChanged( QDate date )
{
  emit dateChanged( date );
  hide();
}

void KDatePickerPopup::slotToday()
{
  emit dateChanged( QDate::currentDate() );
}

void KDatePickerPopup::slotTomorrow()
{
	emit dateChanged( KGlobal::locale()->calendar()->addDays( QDate::currentDate(), 1 ) );
}

void KDatePickerPopup::slotFriday()
{
  const KCalendarSystem *calSys = KGlobal::locale()->calendar();
  QDate date = QDate::currentDate();
  int day = calSys->dayOfWeek(date);
  if ( day < 6 )
    date = calSys->addDays( date, 5 - day );
  else
    date = calSys->addDays( date, 5 - day + 7 );

  emit dateChanged( date );
}

void KDatePickerPopup::slotSunday()
{
  const KCalendarSystem *calSys = KGlobal::locale()->calendar();
  QDate date = QDate::currentDate();
  emit dateChanged( calSys->addDays( date, 7 - calSys->dayOfWeek(date) ) );
}

void KDatePickerPopup::slotNoDate()
{
  emit dateChanged( QDate() );
}

void KDatePickerPopup::slotNextWeek()
{
  emit dateChanged( KGlobal::locale()->calendar()->addDays(QDate::currentDate(),  7 ) );
}

extern QDate addMonths(const QDate &date, int nmonths);

void KDatePickerPopup::slotNextMonth() {
  emit dateChanged(addMonths(QDate::currentDate(), 1));
}

#include "kdatepickerpopup.moc"
