# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Editor General configuration page.
"""

import QScintilla.Lexers

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorGeneralPage import Ui_EditorGeneralPage

import Preferences

class EditorGeneralPage(ConfigurationPageBase, Ui_EditorGeneralPage):
    """
    Class implementing the Editor General configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorGeneralPage")
        
        self.openFilesFilterComboBox.addItems(\
            QScintilla.Lexers.getOpenFileFiltersList(True))
        self.saveFilesFilterComboBox.addItems(\
            QScintilla.Lexers.getSaveFileFiltersList(True))
        
        # set initial values
        self.autosaveSlider.setValue(\
            Preferences.getEditor("AutosaveInterval"))
        self.tabwidthSlider.setValue(\
            Preferences.getEditor("TabWidth"))
        self.indentwidthSlider.setValue(\
            Preferences.getEditor("IndentWidth"))
        self.linenowidthSlider.setValue(\
            Preferences.getEditor("LinenoWidth"))
        self.indentguidesCheckBox.setChecked(\
            Preferences.getEditor("IndentationGuides"))
        self.linenoCheckBox.setChecked(\
            Preferences.getEditor("LinenoMargin"))
        self.foldingCheckBox.setChecked(\
            Preferences.getEditor("FoldingMargin"))
        self.tabforindentationCheckBox.setChecked(\
            Preferences.getEditor("TabForIndentation"))
        self.tabindentsCheckBox.setChecked(\
            Preferences.getEditor("TabIndents"))
        self.converttabsCheckBox.setChecked(\
            Preferences.getEditor("ConvertTabsOnLoad"))
        self.whitespaceCheckBox.setChecked(\
            Preferences.getEditor("ShowWhitespace"))
        self.eolCheckBox.setChecked(Preferences.getEditor("ShowEOL"))
        self.autoindentCheckBox.setChecked(\
            Preferences.getEditor("AutoIndentation"))
        self.bracehighlightingCheckBox.setChecked(\
            Preferences.getEditor("BraceHighlighting"))
        self.automaticEolConversionCheckBox.setChecked(\
            Preferences.getEditor("AutomaticEOLConversion"))
        self.createBackupFileCheckBox.setChecked(\
            Preferences.getEditor("CreateBackupFile"))
        self.automaticSyntaxCheckCheckBox.setChecked(\
            Preferences.getEditor("AutoCheckSyntax"))
        self.defaultEncodingComboBox.setCurrentIndex(\
            self.defaultEncodingComboBox.findText(\
                Preferences.getEditor("DefaultEncoding")))
        self.wrapLongLinesCheckBox.setChecked(\
            Preferences.getEditor("WrapLongLines"))
        self.warnFilesizeSpinBox.setValue(\
            Preferences.getEditor("WarnFilesize"))
        self.clearBreakpointsCheckBox.setChecked(\
            Preferences.getEditor("ClearBreaksOnClose"))
        self.automaticReopenCheckBox.setChecked(\
            Preferences.getEditor("AutoReopen"))
        self.miniMenuCheckBox.setChecked(\
            Preferences.getEditor("MiniContextMenu"))
        self.stripWhitespaceCheckBox.setChecked(\
            Preferences.getEditor("StripTrailingWhitespace"))
        self.openFilesFilterComboBox.setCurrentIndex(\
            self.openFilesFilterComboBox.findText(\
                Preferences.getEditor("DefaultOpenFilter")))
        self.saveFilesFilterComboBox.setCurrentIndex(\
            self.saveFilesFilterComboBox.findText(\
                Preferences.getEditor("DefaultSaveFilter")))
        
    def save(self):
        """
        Public slot to save the Editor General configuration.
        """
        Preferences.setEditor("AutosaveInterval", 
            self.autosaveSlider.value())
        Preferences.setEditor("TabWidth", 
            self.tabwidthSlider.value())
        Preferences.setEditor("IndentWidth", 
            self.indentwidthSlider.value())
        Preferences.setEditor("LinenoWidth", 
            self.linenowidthSlider.value())
        Preferences.setEditor("IndentationGuides",
            int(self.indentguidesCheckBox.isChecked()))
        Preferences.setEditor("LinenoMargin", 
            int(self.linenoCheckBox.isChecked()))
        Preferences.setEditor("FoldingMargin", 
            int(self.foldingCheckBox.isChecked()))
        Preferences.setEditor("TabForIndentation", 
            int(self.tabforindentationCheckBox.isChecked()))
        Preferences.setEditor("TabIndents", 
            int(self.tabindentsCheckBox.isChecked()))
        Preferences.setEditor("ConvertTabsOnLoad",
            int(self.converttabsCheckBox.isChecked()))
        Preferences.setEditor("ShowWhitespace", 
            int(self.whitespaceCheckBox.isChecked()))
        Preferences.setEditor("ShowEOL", 
            int(self.eolCheckBox.isChecked()))
        Preferences.setEditor("AutoIndentation", 
            int(self.autoindentCheckBox.isChecked()))
        Preferences.setEditor("BraceHighlighting",
            int(self.bracehighlightingCheckBox.isChecked()))
        Preferences.setEditor("AutomaticEOLConversion",
            int(self.automaticEolConversionCheckBox.isChecked()))
        Preferences.setEditor("CreateBackupFile",
            int(self.createBackupFileCheckBox.isChecked()))
        Preferences.setEditor("AutoCheckSyntax",
            int(self.automaticSyntaxCheckCheckBox.isChecked()))
        Preferences.setEditor("DefaultEncoding",
            unicode(self.defaultEncodingComboBox.currentText()))
        Preferences.setEditor("WrapLongLines",
            int(self.wrapLongLinesCheckBox.isChecked()))
        Preferences.setEditor("WarnFilesize",
            self.warnFilesizeSpinBox.value())
        Preferences.setEditor("ClearBreaksOnClose",
            int(self.clearBreakpointsCheckBox.isChecked()))
        Preferences.setEditor("AutoReopen",
            int(self.automaticReopenCheckBox.isChecked()))
        Preferences.setEditor("MiniContextMenu",
            int(self.miniMenuCheckBox.isChecked()))
        Preferences.setEditor("StripTrailingWhitespace", 
            int(self.stripWhitespaceCheckBox.isChecked()))
        Preferences.setEditor("DefaultOpenFilter",
            self.openFilesFilterComboBox.currentText())
        Preferences.setEditor("DefaultSaveFilter",
            self.saveFilesFilterComboBox.currentText())
        
    def on_tabforindentationCheckBox_toggled(self, checked):
        """
        Private slot used to set the tab conversion check box.
        
        @param checked flag received from the signal (boolean)
        """
        if checked and self.converttabsCheckBox.isChecked():
            self.converttabsCheckBox.setChecked(not checked)
        self.converttabsCheckBox.setEnabled(not checked)
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorGeneralPage()
    return page
