# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Interface (part 2) configuration page.
"""

import glob
import os

from PyQt4.QtCore import pyqtSignature, QVariant, QTranslator, QString

from ConfigurationPageBase import ConfigurationPageBase
from Ui_Interface2Page import Ui_Interface2Page

import Preferences
import Utilities

from eric4config import getConfig

class Interface2Page(ConfigurationPageBase, Ui_Interface2Page):
    """
    Class implementing the Interface (part 2) configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("Interface2Page")
        
        # set initial values
        self.__populateLanguageCombo()
        layout = Preferences.getUILayout()
        if layout[0] == "DockWindows":
            index = 0
        elif layout[0] == "FloatingWindows":
            index = 1
        else:
            index = 0   # default for bad values
        self.layoutComboBox.setCurrentIndex(index)
        if layout[1] == 0:
            self.separateShellButton.setChecked(True)
        else:
            self.debugEmbeddedShellButton.setChecked(True)
        if layout[2] == 0:
            self.separateFileBrowserButton.setChecked(True)
        elif layout[2] == 1:
            self.debugEmbeddedFileBrowserButton.setChecked(True)
        else:
            self.projectEmbeddedFileBrowserButton.setChecked(True)
        
    def save(self):
        """
        Public slot to save the Interface configuration.
        """
        # save the language settings
        uiLanguageIndex = self.languageComboBox.currentIndex()
        if uiLanguageIndex:
            uiLanguage = unicode(\
                self.languageComboBox.itemData(uiLanguageIndex).toString())
        else:
            uiLanguage = None
        Preferences.setUILanguage(uiLanguage)
        
        # save the interface layout settings
        if self.separateShellButton.isChecked():
            layout2 = 0
        else:
            layout2 = 1
        if self.separateFileBrowserButton.isChecked():
            layout3 = 0
        elif self.debugEmbeddedFileBrowserButton.isChecked():
            layout3 = 1
        else:
            layout3 = 2
        if self.layoutComboBox.currentIndex() == 0:
            layout1 = "DockWindows"
        elif self.layoutComboBox.currentIndex() == 1:
            layout1 = "FloatingWindows"
        else:
            layout1 = "DockWindows"
        layout = (layout1, layout2, layout3)
        Preferences.setUILayout(layout)
        
    def __populateLanguageCombo(self):
        """
        Private method to initialize the language combobox of the Interface 
        configuration page.
        """
        self.languageComboBox.clear()
        
        fnlist = glob.glob("eric4_*.qm") + \
            glob.glob(os.path.join(getConfig('ericTranslationsDir'), "eric4_*.qm")) + \
            glob.glob(os.path.join(Utilities.getConfigDir(), "eric4_*.qm"))
        locales = {}
        for fn in fnlist:
            locale = os.path.basename(fn)[6:-3]
            if not locales.has_key(locale):
                translator = QTranslator()
                translator.load(fn)
                locales[locale] = \
                    translator.translate("InterfacePage", "English", 
                                         "Translate this with your language") + \
                    QString(" (%1)").arg(locale)
        localeList = locales.keys()
        localeList.sort()
        
        try:
            uiLanguage = unicode(Preferences.getUILanguage())
            if uiLanguage == "None":
                currentIndex = 0
            elif uiLanguage == "System":
                currentIndex = 1
            else:
                currentIndex = localeList.index(uiLanguage) + 2
        except ValueError:
            currentIndex = 0
        self.languageComboBox.clear()
        
        self.languageComboBox.addItem("English (default)", QVariant("None"))
        self.languageComboBox.addItem(self.trUtf8('System'), QVariant("System"))
        for locale in localeList:
            self.languageComboBox.addItem(locales[locale], QVariant(locale))
        self.languageComboBox.setCurrentIndex(currentIndex)
        
    @pyqtSignature("")
    def on_resetLayoutButton_clicked(self):
        """
        Private method to reset layout to factory defaults
        """
        Preferences.resetLayout()
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = Interface2Page()
    return page
