#ifndef ETPAN_FOLDER_DISCOVER_H

#define ETPAN_FOLDER_DISCOVER_H

#include <libetpan/libetpan.h>
#include "etpan-folder-discover-types.h"
#include "etpan-folder-params-types.h"

struct etpan_discovery_manager *
etpan_discovery_manager_new(struct etpan_app * app);

void etpan_discovery_manager_free(struct etpan_discovery_manager * manager);

int etpan_discovery_manager_add(struct etpan_discovery_manager * manager,
    struct etpan_discovery_info * info);

struct etpan_discovery_info * etpan_discovery_info_new(int type,
    struct mailstorage * storage, char * start_path, char * vpath,
    struct etpan_account_info * account,
    char * sent_folder,
    char * draft_folder);

void etpan_discovery_info_free(struct etpan_discovery_info * info);

int etpan_discover_update_config(struct etpan_discovery_manager * manager,
    struct etpan_folder_params * folder_params,
    struct etpan_discovery_info * info);

int etpan_discovery_info_update(struct etpan_discovery_info * info);

#endif
