/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-imf-helper.h,v 1.11 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_IMF_HELPER_H

#define ETPAN_IMF_HELPER_H

#include <libetpan/libetpan.h>
#include "etpan-cfg-global-types.h"
#include "etpan-cfg-account-types.h"
#include "etpan-imf-helper-types.h"
#include "etpan-app-types.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

struct mailimf_mailbox_list *
etpan_address_to_mailbox_list(struct mailimf_address_list * addr_list);

struct mailimf_address_list *
etpan_mailbox_to_address_list(struct mailimf_mailbox_list * mb_list);

int etpan_append_address_list(struct mailimf_address_list * new_addr_list,
    struct mailimf_address_list * addr_list);

int etpan_append_mailbox_list(struct mailimf_mailbox_list * new_mb_list,
    struct mailimf_mailbox_list * mb_list);

struct mailimf_address_list *
etpan_dup_address_list(struct mailimf_address_list * addr_list);

struct mailimf_mailbox_list *
etpan_dup_mailbox_list(struct mailimf_mailbox_list * mb_list);

struct mailimf_mailbox * etpan_dup_mailbox(struct mailimf_mailbox * mb);

struct mailimf_address * etpan_dup_address(struct mailimf_address * addr);

struct mailimf_group * etpan_dup_group(struct mailimf_group * group);

int etpan_set_current_newsgroups_header(struct mailimf_fields * new_fields,
    struct mailfolder * post_folder);

int etpan_set_xmailer(struct mailimf_fields * new_fields,
    int nntp_protocol);

int etpan_set_resentxmailer(struct mailimf_fields * new_fields,
    int nntp_protocol);

int etpan_is_nntp_protocol(struct mailfolder * folder);

int
etpan_get_to_cc_address(struct mailimf_single_fields * single_fields,
    struct mailimf_address_list ** result);

char * mailimf_date_time_to_string(struct mailimf_date_time * date_time);

char *
mailimf_mailbox_to_string(struct mailimf_mailbox * mb);

char *
mailimf_mailbox_list_to_string(struct mailimf_mailbox_list * mb_list);

char *
mailimf_group_to_string(struct mailimf_group * group);

char *
mailimf_address_to_string(struct mailimf_address * address);

char *
mailimf_address_list_to_string(struct mailimf_address_list * addr_list);

void etpan_get_from_value(struct mailimf_single_fields * fields,
    char ** from, int * is_addr);

char * etpan_dup_imf_file(char * source_filename);

#endif
