/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: eceinternal.h
 */


/* contains all the defination used internally by ece */

#ifndef __ECEINTERNAL_H__
#define __ECEINTERNAL_H__ 1

#include <pthread.h>
#include <plugin.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include <errno.h>


#define ECE_MSG 	"ecemsgv"
#define ECE_ACKMSG 	"eceackv"

#define ECE_ACK 	"eceackn"
#define ECE_MCAST 	"ecemctn"
#define ECE_CMD 	"ececmdn"
#define ECE_CORRELATOR 	"ececorrn"
#define ECE_FIRSTNODE 	"ecefrstndn"
#define ECE_TRANSID 	"ecetransn"
#define ECE_DATA   	"ecedatan"
#define ECE_CRC   	"ececrcn"

#define ECEi_TOWHOM 	"ecetowhomn"
#define ECEi_LLM    	"ecellmn"
#define ECEi_NODECOUNT 	"ecenodcntn"
#define ECEi_MYNODEID 	"ecemyndn"
#define ECEi_NODES  	"ecenodesn"
#define ECEi_MEMBERSHIP "ecemembn"
#define ECEi_QUORUM 	"eceqrmn"
#define ECEi_MEM 	"ecememn"
#define ECEi_ECESTAT 	"ecestatn"


#define ECE_WHO   	"ecewhon"
#define ECE_SLAVE 	"eceslvv"
#define ECE_MASTER 	"ecemstv"
#define ECE_JOINSTATUS 	"ecejstv"

#define ECE_RET   	"eceretn"



#define ECEFIFO 	"/tmp/ece" 
	/* TOBEDONE 
	 * this is the UDP socket file used to 
	 * communicate between master and the 
	 * slave.
	 * Change this to a convinient location 
	 * which is only accessible by the root 
	 */

extern plugin_record_t ece_plugin_record;
extern engine_functions_t *gl_ece_engine_funcs;

#define my_plugin_record &ece_plugin_record
#define EngFncs gl_ece_engine_funcs

#define __THREAD__ (char*)( (pthread_self() == gl_rsct_thread)? "rsct-thread":((pthread_self() == gl_appcb_thread)?"appcb-thread":"main-thread"))

#define ECELOG_WARNING(msg, args...)	(void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		WARNING,    &ece_plugin_record, " %s:%s: " msg, \
		__THREAD__, __FUNCTION__  , ## args))
#define ECELOG(msg, args...)		(void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		DEFAULT,    &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__, __FUNCTION__ , ## args))
#define ECELOG_DETAILS(msg, args...)	 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		DETAILS,    &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_DEBUG(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		DEBUG,      &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_EXTRA(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		EXTRA,      &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_PROC(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		ENTRY_EXIT, &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_EVERYTHING(msg, args...)	 (void )(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		EVERYTHING, &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_ERROR(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		ERROR, &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_SERIOUS(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		SERIOUS, &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_CRITICAL(msg, args...)		 (void)(gl_ece_engine_funcs && \
		gl_ece_engine_funcs->write_log_entry && \
		gl_ece_engine_funcs->write_log_entry(\
		CRITICAL, &ece_plugin_record, "%s:%s: " msg, \
		__THREAD__,__FUNCTION__ , ## args))
#define ECELOG_ENTRY()	(void )(ECELOG_PROC("Enter\n"))
#define ECELOG_EXIT(x)	(void )(ECELOG_PROC("Exit: rc = %d\n", x))
#define ECELOG_EXITVOID()	(void )(ECELOG_PROC("Exit:\n"))
#define RETURN(x)	do { ECELOG_EXIT(x); return(x); } while (0)
#define RETURNVOID()	do { ECELOG_EXITVOID(); return; } while (0)
#define ENGINE_ALLOC(size)   ((gl_ece_engine_funcs && \
		gl_ece_engine_funcs->engine_alloc) ?\
		gl_ece_engine_funcs->engine_alloc(size):\
		NULL)
#define CALC_CRC(crc, buf, bufsize) ((gl_ece_engine_funcs && \
		gl_ece_engine_funcs->calculate_CRC)?\
		gl_ece_engine_funcs->calculate_CRC(\
		crc, (buf), bufsize):0)

#define SET_STRING(a, b) \
	a = ENGINE_ALLOC(strlen(b)+1); \
	if (a) {\
		strcpy(a, b);\
	} else {\
		RETURN(ENOMEM);\
	}


typedef enum {
	MASTER,
        SLAVE
} ece_mode_t;

#endif /* __ECEINTERNAL_H__ */
