/***************************************************************************
                          FLAction.h  -  description
                             -------------------
    begin                : dom jun 30 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLACTION_H
#define FLACTION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qstring.h>

/** Esta clase contiene informacin de acciones para abrir formularios.

    Se utiliza para enlazar automticamente formularios con su parte de proceso,
    interfaz y opcionalmente un cursor.

    @author Federico Albujer Zornoza
    @version 0.4 */
class FLAction
{
    public:
	
    /** constructor */
    FLAction();

    /** destructor */
    ~FLAction();

    /** Establece el nombre de la accion */
    void setName( const QString & n )
    {
        name_=n;
    }

    /** Establece el proceso asociado a la accion */
    void setProcess( const QString & p )
    {
        process_=p;
    }

    /** Establece el proceso asociado a la accion */
    void setMasterProcess( const QString & p )
    {
        masterProcess_=p;
    }

    /** Establece la tabla asociada a la accion */
    void setTable( const QString & t )
    {
        table_=t;
    }

    /** Establece el formulario asociado a la accion */
    void setForm( const QString & f )
    {
        form_= QString (FLDATA) + "/facturalux/forms/" + f;
    }

    /** Establece el texto de la barra de ttulo del formulario */
    void setCaption( const QString & c )
    {
        caption_=c;
    }

    /** Obtiene el nombre de la accion */
    const QString & name () const
    {
        return name_;
    }

    /** Obtiene  el proceso asociado a la accion */
    const QString & process () const
    {
        return process_;
    }

    /** Obtiene  el proceso maestro asociado a la accion */
    const QString & masterProcess () const
    {
        return masterProcess_;
    }

    /** Obtiene  la tabla asociada a la accion */
    const QString & table () const
    {
        return table_;
    }

    /** Obtiene el texto de la barra de ttulo del formulario */
    const QString & caption () const
    {
        return caption_;
    }

    /** Obtiene el formulario asociado a la accion */
    const QString & form () const
    {
        return form_;
    }

    private:

    /** Nombre de la accion */
    QString name_;

    /** Proceso asociado a la accion */
    QString process_;

    /** Proceso maestro asociado a la accion */
    QString masterProcess_;

    /** Tabla asociada a la accion */
    QString table_;

    /** Formulario asociado a la accion */
    QString  form_;

    /** Texto que debe tener la barra de ttulo del formulario */
    QString caption_;
};

#endif
