#ifndef HLDAT_H
#define HLDAT_H

#include <glib.h>
#include <gdk_imlib.h>
#include <stdio.h>

typedef struct {
  char *filename;
  FILE *file;
  int numicons;
  struct Icon_ *icons;
  int numsounds;
  struct HFSound_ *sounds;
} HotlineFile;

typedef struct Icon_ {
  char *name;
  int number;
  int width,height;
  GdkImlibImage *image;
  GdkPixmap     *pixmap,*full_pixmap;
  GdkBitmap     *mask,*full_mask;
  size_t offset,size;
  HotlineFile *hf;
} Icon;

typedef struct HFSound_ {
  HotlineFile *hf;
  int number;
  size_t offset,size;
  int esd_id;
} HFSound;

#define MAX_ICON_NUM 65535

typedef enum {
  HL_SOUND_CHAT=129,
  HL_SOUND_LOGGED_IN=130,
  HL_SOUND_LOGOUT=131,
  HL_SOUND_SERVMSG=132,
  HL_SOUND_LOGIN=133,
  HL_SOUND_ERROR=134,
  HL_SOUND_FILEDONE=135,
  HL_SOUND_DOORBELL=136,
  HL_SOUND_MAX=137
} HLSound;

void init_hotline_dat(void);
void get_icon_by_num(int num,GdkPixmap **image,GdkBitmap **mask,int *width);
Icon *get_icon(int num);
GdkImlibImage *get_image_icon(int num,int min_w,int min_h,gboolean as_is);
void get_image_of_icon(int num,GdkPixmap **image,GdkBitmap **mask);

void for_all_icons(gboolean SMALL,void (*func)(Icon *,gpointer),gpointer);
void load_all_icons(GtkWidget *progressbar);

void play_sound(HLSound id);

#endif
