#ifndef THREAD_H
#define THREAD_H

#include <pthread.h>
#include <glib.h>

typedef pthread_t Thread;
typedef void (*VoidFunc)(gpointer);

gboolean newThread(Thread *t,
		   VoidFunc startFunc,
		   VoidFunc endFunc,
		   gpointer data);

void killThread(Thread t);

pthread_cond_t *cond_new(void);
pthread_mutex_t *mutex_new(void);
void mutex_free(pthread_mutex_t *m);
void cond_free(pthread_cond_t *c);

#endif
