/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

void wave ( char type, char *data ) {

	int i, x1, x2, y1, y2;
	float start_angle, a1, a2, r1, r2;

	switch ( type ) {

		case WAVE_HORIZONTAL_STEREO_THIRDS:
			for ( i = 0; i < XRes; i++ ){
				x1 = i;
				x2 = i + 1;
				y1 = YRes / 3 * 1 - ( data[i*4] + data[i*4+1] * 0x100 * YRes / 2 ) / 0x10000;
				if ( y1 < 0 ) y1 = 0;
				y2 = YRes / 3 * 1 - ( data[(i+1)*4] + data[(i+1)*4+1] * 0x100 * YRes / 2 ) / 0x10000;
				if ( y2 < 0 ) y2 = 0;
				line ( x1, y1, x2, y2, color1 );
				x1 = i;
				x2 = i + 1;
				y1 = YRes / 3 * 2- ( data[i*4+2] + data[i*4+3] * 0x100 * YRes / 2 ) / 0x10000;
				if ( y1 > YRes ) y1 = YRes;
				y2 = YRes / 3 * 2 - ( data[(i+1)*4+2] + data[(i+1)*4+3] * 0x100 * YRes / 2 ) / 0x10000;
				if ( y2 > YRes ) y2 = YRes;
				line ( x1, y1, x2, y2, 0xffffffff - color1 + 0xff );
			}
			break;

		case WAVE_CIRCLE_STEREO_TWIST:
			start_angle = (float)SDL_GetTicks ( ) * PI / 500.0;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+0] + data[i*4+1] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+0] + data[(i+1)*4+1] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, color1 );
			}
			start_angle += PI;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+2] + data[i*4+3] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+2] + data[(i+1)*4+3] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, 0xffffffff - color1 + 0xff );
			}
			break;

		case WAVE_ELLIPSE_STEREO_TWIST:
			start_angle = (float)SDL_GetTicks ( ) * PI / 500.0;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+0] + data[i*4+1] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) ) * ( XRes / YRes );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+0] + data[(i+1)*4+1] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) ) * ( XRes / YRes );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, color1 );
			}
			start_angle += PI;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+2] + data[i*4+3] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) ) * ( XRes / YRes );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+2] + data[(i+1)*4+3] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) ) * ( XRes / YRes );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, 0xffffffff - color1 + 0xff );
			}
			break;

		case WAVE_CIRCLE_STEREO_STEADY:
			start_angle = PI / 4;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+0] + data[i*4+1] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+0] + data[(i+1)*4+1] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, color1 );
			}
			start_angle += PI;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+2] + data[i*4+3] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+2] + data[(i+1)*4+3] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, 0xffffffff - color1 + 0xff );
			}
			break;

		case WAVE_ELLIPSE_STEREO_STEADY:
			start_angle = PI / 4;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+0] + data[i*4+1] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) ) * ( XRes / YRes );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+0] + data[(i+1)*4+1] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) ) * ( XRes / YRes );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, color1 );
			}
			start_angle += PI;
			for ( i = 0; i < XRes; i++ ) {
				a1 = start_angle + (float)i * PI / (float) XRes;
				r1 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[i*4+2] + data[i*4+3] * 0x100 ) / 39200.0 );
				x1 = XRes / 2 + (int)( r1 * sin ( a1 ) ) * ( XRes / YRes );
				y1 = YRes / 2 + (int)( r1 * cos ( a1 ) );
				a2 = start_angle + (float)( i + 1 ) * PI / (float) XRes;
				r2 = ( (float)YRes / 4.0 ) * ( 1 + (float)( data[(i+1)*4+2] + data[(i+1)*4+3] * 0x100 ) / 39200.0 );
				x2 = XRes / 2 + (int)( r2 * sin ( a2 ) ) * ( XRes / YRes );
				y2 = YRes / 2 + (int)( r2 * cos ( a2 ) );
				line ( x1, y1, x2, y2, 0xffffffff - color1 + 0xff );
			}
			break;
	}
}

void beatmark ( int type ) {

	float angle, x1, y1, x2, y2;
	int x,y;	

	switch ( type ) {

		case BEATMARK_X:
			line ( XRes / 10, YRes / 10, XRes * 4 / 10, YRes * 4 / 10, 0xffffffff );
			line ( XRes * 6 / 10, YRes * 6 / 10, XRes * 9 / 10, YRes * 9 / 10, 0xffffffff );
			line ( XRes * 9 / 10, YRes / 10, XRes * 6 / 10, YRes * 4 / 10, 0xffffffff );
			line ( XRes * 4 / 10, YRes * 6 / 10, XRes / 10, YRes * 9 / 10, 0xffffffff );
			break;

		case BEATMARK_A:
			line ( XRes * 4 / 10, YRes * 1 / 10, XRes * 1 / 10, YRes * 4 / 10, 0xffffffff );
			line ( XRes * 6 / 10, YRes * 1 / 10, XRes * 9 / 10, YRes * 4 / 10, 0xffffffff );
			line ( XRes * 1 / 10, YRes * 6 / 10, XRes * 4 / 10, YRes * 9 / 10, 0xffffffff );
			line ( XRes * 6 / 10, YRes * 9 / 10, XRes * 9 / 10, YRes * 6 / 10, 0xffffffff );
			break;

		case BEATMARK_O:
			for ( angle = 0; angle < 2 * PI; angle += PI / 10 ) {
				x1 = (float)( XRes / 2 ) + (float)( XRes * 2 / 6 ) * sin ( angle );
				y1 = (float)( YRes / 2 ) + (float)( YRes * 2 / 6 ) * cos ( angle );
				x2 = (float)( XRes / 2 ) + (float)( XRes * 5 / 12 ) * sin ( angle );
				y2 = (float)( YRes / 2 ) + (float)( YRes * 5 / 12 ) * cos ( angle );
				line ( (int)x1, (int)y1, (int)x2, (int)y2, 0xffffffff );
			}
			break;

		case BEATMARK_Q:
			for ( angle = 0; angle < 2 * PI; angle += PI / 50 ) {
				x1 = (float)( XRes / 2 ) + (float)( XRes * 2 / 6 ) * sin ( angle );
				y1 = (float)( YRes / 2 ) + (float)( YRes * 2 / 6 ) * cos ( angle );
				x2 = (float)( XRes / 2 ) + (float)( XRes * 31 / 90 ) * sin ( angle );
				y2 = (float)( YRes / 2 ) + (float)( YRes * 31 / 90 ) * cos ( angle );
				line ( (int)x1, (int)y1, (int)x2, (int)y2, 0xffffffff );
			}
			break;
		
		case BEATMARK_D:
			for ( x = XRes / 19; x <= XRes / 19 * 18; x += XRes / 19 ) {
				for ( y = YRes / 19; y <= YRes / 19 * 18; y += YRes / 19 ) {
					line ( x, y, x + 1, y + 1, 0xffffffff );
				}
			}
			break;
		
	}
}
