/* $Header: /home/yav/catty/fkiss/RCS/comment.c,v 1.3 2000/08/24 02:10:48 yav Exp $
 * fkiss cel comment display
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

char id_comment[] = "$Id: comment.c,v 1.3 2000/08/24 02:10:48 yav Exp $";

#include <X11/Xlib.h>
#include <stdio.h>

#include "config.h"

#include "headers.h"
#include "fkiss.h"
#include "work.h"

#define PUBLIC_COMMENT_C
#include "extern.h"

#define COMWIN_BORDER
#define COMWIN_XOFS 8
#define COMWIN_YOFS (-8)
#define COMWIN_LINE_SPACE 16
#define COMWIN_UPPER_MARGIN 4
#define COMWIN_LOWER_MARGIN 6	/* within font descent */
#define COMWIN_LEFT_MARGIN 4
#define COMWIN_RIGHT_MARGIN 4
#define COMWIN_NUMBER_WIDTH 40

static Bool comwin_created = False;
static int comment_cel = -1;

int expose_comment_line(d, n, x, y, mark, rw, rh)
     Drawable d;		/* Drawable */
     int n;			/* cel number */
     int x, y;			/* base point position (pixel) */
     int mark;			/* mark character */
     int *rw;			/* width return pointer */
     int *rh;			/* height return pointer */
{
  int i, r, w, h;
  char *p;
  char buf[256];		/* cnf line must be shorter than 256 bytes */
  
  if (comment_linenum) {
    /* with line number */
    sprintf(buf, "%4d%c", (cell + n)->line, mark);
    draw_string(d, x, y, buf);
    x += COMWIN_NUMBER_WIDTH;
  }
  r = w = h = 0;
  p = (cell + n)->comment;
  if (p != NULL) {
    while (*p) {
      for (i = 0; i < sizeof(buf)-1; i++) {
	if (*p == '\0')
	  break;
	if (*p == '\n') {
	  p++;
	  break;
	}
	buf[i] = *p++;
      }
      buf[i] = '\0';
      i = draw_string(d, x, y, buf);
      if (i > w)
	w = i;
      y += COMWIN_LINE_SPACE;
      h += COMWIN_LINE_SPACE;
      r++;
    }
  }
  if (comment_linenum) {
    w += COMWIN_NUMBER_WIDTH;
    if (!r) {
      r++;
      h += COMWIN_LINE_SPACE;
    }
  }
  if (rw != NULL)
    *rw = w;
  if (rh != NULL)
    *rh = h;
  return r;			/* line count */
}

/* draw comment to comment window
 * and return drawn area geometry
 */
int expose_comment_sub(d, celn, x, y, rw, rh)
     Drawable d;		/* drawing window or pixmap or None */
     int celn;			/* cel number */
     int x, y;			/* base point */
     int *rw;			/* drawing area width return */
     int *rh;			/* drawing area height return */
{
  int i, n, r, w, h;

  if (celn < 0)
    return 0;			/* illegal cel number, No line printed */
  r = 0;
  switch (comment_mode) {
  case 1:
    r = expose_comment_line(d, celn, x, y, 0, rw, rh);
    break;
  case 2:
    if (rw != NULL)
      *rw = 0;
    if (rh != NULL)
      *rh = 0;
    for (i = 0; i < celcnt; i++) {
      if ((cell + i)->width &&
	  ((cell + i)->obj == (cell + celn)->obj) &&
	  ((cell + i)->comment != NULL)) {
	n = expose_comment_line(d, i, x, y, (i == celn ? '*' : ' '), &w, &h);
	y += n * COMWIN_LINE_SPACE;
	r += n;
	if (rw != NULL && w > *rw)
	  *rw = w;
	if (rh != NULL)
	  *rh += h;
      }
    }
    break;
  }
  return r;			/* line count */
}

void expose_comment(ev)
     XExposeEvent *ev;
{
  if (!ev->count) {
    /* redraw at last event only */
    expose_comment_sub(comwin, comment_cel,
		       COMWIN_LEFT_MARGIN,
		       COMWIN_UPPER_MARGIN + COMWIN_LINE_SPACE,
		       NULL, NULL);
  }
}

void unmap_comment()
{
  if (comwin_created)
    XUnmapWindow(dsp, comwin);
}

void map_comment(ev)
     XButtonEvent *ev;
{
  int i, x, y, w, h;
  XSetWindowAttributes atr;
  Window child;

  if (!comment_mode)
    return;
  x = ev->x;
  y = ev->y;
  comment_cel = search_cell(x, y);
  if (expose_comment_sub(None, comment_cel, 0, 0, &w, &h) <= 0) {
    unmap_comment();
    return;
  }
  XTranslateCoordinates(dsp, ev->window, rootwin, x, y, &x, &y, &child);
  w += COMWIN_LEFT_MARGIN + COMWIN_RIGHT_MARGIN;
  h += COMWIN_UPPER_MARGIN + COMWIN_LOWER_MARGIN;
  x += COMWIN_XOFS;
  y += COMWIN_YOFS - h;
  if (x + w > DisplayWidth(dsp, scr))
    x = DisplayWidth(dsp, scr) - w;
  if (y + h > DisplayHeight(dsp, scr))
    y = DisplayHeight(dsp, scr) - h;
  if (x < 0)
    x = 0;
  if (y < 0)
    y = 0;
  if (comwin_created) {
    unmap_comment();		/* to send expose event */
    XMoveResizeWindow(dsp, comwin, x, y, w, h);
  } else {
    comwin = XCreateSimpleWindow(dsp, rootwin,
				 x, y, w, h, combw,
				 spx[SPX_FG], spx[SPX_BG]);
    XSelectInput(dsp, comwin, ExposureMask|ButtonPressMask
		 |EnterWindowMask|KeyPressMask);
    XSetTransientForHint(dsp, comwin, topwin);
    atr.override_redirect = True;
    atr.save_under = True;
    i = CWOverrideRedirect|CWSaveUnder;
    XChangeWindowAttributes(dsp, comwin, i, &atr);
    comwin_created = True;
  }
  XMapRaised(dsp, comwin);
}

/* End of file */
