#!/usr/bin/env python

import unittest
import datatransfer, datatransfer_skel

from orbrunner import ORBRunner

#
# The test case for "long" type transmission.
#
class LongTest(unittest.TestCase):

    def __init__(self, orb_runner):
        unittest.TestCase.__init__(self)
        self.orb_runner = orb_runner;

    #
    # Create the implementation of the "long" type test interface and
    # register it with the ORB.
    #
    def setUp(self):
        orb = self.orb_runner.getORB()
        stringified_ior = open('long.ref', 'r').read()
        self.obj = orb.string_to_object(stringified_ior)

    def tearDown(self):
        # Do nothing for the time being
        pass

    #
    # Perform the "long" type interface tests.
    #
    def runTest(self):
        long = 42

        self.assertEqual(self.obj.longIn(long), long)
        
        self.assertEqual(self.obj.longOut(long), long)

        long_in = 13
        (long_ret, long_out) = self.obj.longInOut(long, long_in)

        self.assertEqual(long_ret, long_in)
        self.assertEqual(long_out, long)

#
# Create a testsuite for testing "long" type transmission. This is
# meant to be used by other modules wanting to incorporate these
# tests.
#
def build_test_suite(orb_runner):
    long_test = LongTest(orb_runner)
    test_suite = unittest.TestSuite([long_test])
    return test_suite

#
# Run the tests with an ORB. This is meant to be used when this module
# is executed as a stand-alone program.
#
def run_tests():
    orb_runner = ORBRunner()

    test_suite = build_test_suite(orb_runner)

    test_runner = unittest.TextTestRunner()
    test_runner.run(test_suite)

#
# If this module was loaded as a program, then run the tests.
#
if __name__ == "__main__":
    run_tests()
