/*  Gpasman, a password manager
    Copyright (C) 1998, 1999 Olivier Sessink, olivier@lx.student.wau.nl

    Other code contributors:    
    Dave Rudder 
    Chris Halverson
    Matthew Palmer
    Guide Berning
    Jimmy Mason
	 website at http://www.student.wau.nl/~olivier/gpasman/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#define GPASMAN_NAME "Gpasman 1.3.1"

#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#include "file.h"

int main (int argc, gchar * argv[]) {
   gchar *entry[4];
   gint retval, count;

   if(argc != 3){
      g_print("invalid number of arguments\n");
      exit (1);
   }
   retval = load_init(argv[1], argv[2]);
   switch (retval) {
      case 1: /* everything went allright */
	 break;
      case 0:
         g_print("Can't open file\n");
	 return 0;
      case -1:
         g_print("File permissions bad, should be -rw------\n");
	 return -1; 
      case -2:
         g_print("File is a symlink\n");
	 return -2;
      case -3:
         g_print("Can't get file status\n");
	 return -3;
      default:
         g_print("Internal program error\n");
	 return -4;
   }
   retval = load_entry(entry);
	 
   while (retval == 1) {
      g_print("Server=\"%s\"\n"
		"Username=\"%s\"\n"
		"Password=\"%s\"\n"
		"Comment=\"%s\"\n\n",
		      entry[0], entry[1], entry[2], entry[3]);
      for (count = 0; count < 4; count++) {
         g_free(entry[count]);
      }
      retval = load_entry(entry);
   }
   if (retval != 2)
	   g_print("load_file: error retval=%d\n", retval);
   retval = load_finalize();
   return 1;
}
