/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __FREEBIRTH_H

#include <gtk/gtk.h>

#ifndef __GTK_DIAL_H__
 #include "gtkdial.h"
#endif

#ifndef __DELAY_PANEL_H
 #include "delay_panel.h"
#endif

#ifndef __REVERB_PANEL_H
 #include "reverb_panel.h"
#endif

#ifndef __OSC_H
 #include "oscillator.h"
#endif
#ifndef __ENV_H
 #include "envelope.h"
#endif

#ifndef __SEQ_H
 #include "sequencer.h"
#endif
#ifndef __EVENT_H
 #include "event.h"
#endif

#ifndef __FILTER_H
 #include "filter.h"
#endif

#ifndef __MIX_H
 #include "mixer.h"
#endif

#ifndef __DELAY_H
 #include "delay.h"
#endif

#ifndef __REVERB_H
 #include "reverb.h"
#endif

#ifndef __BLENDER_H
 #include "blender.h"
#endif

#ifndef __SAMPLE_PRODUCER_H
 #include "sample_producer.h"
#endif

#ifndef __RAW_WAVE_H
 #include "raw_wave.h"
#endif

#ifndef __SAMPLE_FREQ_STRIP_H
 #include "sample_freq_strip.h"
#endif

/* three oscilators */
osc        *bass_sin;
osc        *bass_sqr;
osc        *bass_saw;
/*samples */
raw_wave   *kick;
raw_wave   *snare;
raw_wave   *cl_hat;
raw_wave   *op_hat;
raw_wave   *samp_1;


/*shapers */
filter     *bass_filt;
env        *bass_e;
multi_tap_delay      *eff_1;
reverb     *eff_2;
env	   *filt_e;

/* convenient memory to put them in */
sample_producer **sources;

blender    *osc_blender;
mixer      *left_mixer;
mixer      *right_mixer;
mixer      *aux_1;
mixer      *aux_2;
seq        *sequencer;

int bass_saw_event_handle;
int bass_sqr_event_handle;
int bass_sin_event_handle;
int bass_env_event_handle;
int filter_env_event_handle;
int kick_event_handle;
int snare_event_handle;
int cl_hat_event_handle;
int op_hat_event_handle;
int samp1_event_handle;

/*to configure sound device */
int fd;
int format;
int stereo;
int speed;
short *out; /* final output buffer */

/*bool */
int playing;
gint select_id;

/* step button addresses */
GtkWidget *step_btn_addr[16];
GtkWidget *step_led_addr[16];
GtkWidget *wave_type_addr[3];

/*color, visible type stuff */
GtkStyle  *window_style;
GtkStyle  *ia_step_style;/*inactive step style */ 
GtkStyle  *a_step_style; /*inactive step style */
GtkStyle  *dial_style;
GtkStyle  *label_style;
GtkStyle  *slider_style;

GdkPixmap *i_led; /*inactive led */
GdkPixmap *a_led; /*active led */


void init_tbass();
void set_bass_type(int type);
void set_bass_freq(int type);

void init_interface(int argc , char* argv[]);
void step_callback(GtkWidget *widget, gpointer data);
void sample_step_callback(GtkWidget *widget, gpointer data);

void freq_callback(GtkAdjustment *adj, gpointer data);
void env_attack_callback(GtkAdjustment *adj, gpointer data);
void env_release_callback(GtkAdjustment *adj, gpointer data); 
void cutoff_callback(GtkAdjustment *adj, gpointer data);
void filt_attack_callback(GtkAdjustment *adj, gpointer data);
void filt_release_callback(GtkAdjustment *adj, gpointer data);

void saw_amp_callback(GtkAdjustment *adj, gpointer data);
void sqr_amp_callback(GtkAdjustment *adj, gpointer data);
void sin_amp_callback(GtkAdjustment *adj, gpointer data);

void saw_phase_callback(GtkAdjustment *adj, gpointer data);
void sqr_phase_callback(GtkAdjustment *adj, gpointer data);
void sin_phase_callback(GtkAdjustment *adj, gpointer data);

void saw_freq_offset_callback(GtkAdjustment *adj, gpointer data);
void sqr_freq_offset_callback(GtkAdjustment *adj, gpointer data);
void sin_freq_offset_callback(GtkAdjustment *adj, gpointer data);

void q_callback(GtkAdjustment *adj, gpointer data);
void gain_callback(GtkAdjustment *adj, gpointer data);
void bpm_callback(GtkAdjustment *adj, gpointer data);

void mixer_callback(GtkAdjustment *adj, gpointer data);
void panner_callback(GtkAdjustment *adj, gpointer data);
void aux_1_callback(GtkAdjustment *adj, gpointer data);
void aux_2_callback(GtkAdjustment *adj, gpointer data);
void mixer_mute_callback(GtkWidget *widget, gpointer data);

void play_callback(GtkWidget *widget, gpointer data);
void stop_callback(GtkWidget *widget, gpointer data);
/* to handle window closing */
void delete_event (GtkWidget *widget, GdkEvent *event, gpointer data);
void sequencer_step_callback(int step);

/*gui stuff */
#define SEQ_SPACING 2

/*sequencer stuff */
#define NUM_STEPS 16

/*mixer stuff */
#define NUM_SAMPLES 5
#define KICK_INDEX 4
#define SNARE_INDEX 3
#define CL_HAT_INDEX 2
#define OP_HAT_INDEX 1
#define SAMP1_INDEX 0
#define BASS_INDEX 5


#define CLIP   25000
#define CLIP_A ((MIX_MAX_AMP - CLIP) * (MIX_MAX_AMP - CLIP))
#define CLIP_B (MIX_MAX_AMP - 2 * CLIP)

/*
  Local Variables:
  mode: font-lock
  End:
*/





