/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   Predrag.Viceic@ci.unil.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "filemanager.h"


FileManager::FileManager(QObject *parent, const char *name)
 : QObject(parent, name)
{
    iterator=new QStrListIterator(filenames);
    tempFilenamePrefix=0;
    tempDir=new QDir(QDir::homeDirPath().append("/.freecycle/temp/"));
    if  (!tempDir->exists()){
        tempDir->mkdir(tempDir->path());
    }
    filenames.setAutoDelete(TRUE);
    purgeTempDir();
}


FileManager::~FileManager()
{
    purgeTempDir();
    delete tempDir;
    delete iterator;
}




/*!
    \fn FileManager::setFilename(QString)
 */
void FileManager::setFilename(QString _fn)
{
    filename=_fn;
    tempFilenamePrefix=QDateTime::currentDateTime().toTime_t();
    filenames.clear();
}


/*!
    \fn FileManager::getFilename()
 */
const QString FileManager::getFilename()
{
    return iterator->current();
}


/*!
    \fn FileManager::getNextFilename()-
 */
const QString FileManager::getNextFilename()
{
    QString temp;
    if(filenames.isEmpty()){
        temp=QString::number(tempFilenamePrefix).append("_0");
        temp.prepend(tempDir->path().append("/"));
        filenames.append(temp);
        iterator->toLast();
        //std::cout<<"is empty\n";
    }else{
        if(iterator->atLast()){
            temp= QString::number(tempFilenamePrefix).append("_").append(QString::number(filenames.count()));
            temp.prepend(tempDir->path().append("/"));
            filenames.append(temp);
            iterator->toLast();
            //std::cout<<"at last\n";
    }else{

            temp=iterator->operator++();
            //if(!iterator->atLast()) iterator->operator++();
        }
    }
    return temp;
}


/*!
    \fn FileManager::getPreviousFilename()
 */
const QString FileManager::getPreviousFilename()
{
    if(iterator->atFirst()){
        return iterator->current();;
    }
    else{
        QString temp= iterator->operator--();
        if(iterator->atLast()) iterator->operator--();
        return temp;
    }
}


/*!
    \fn FileManager::getOriginalFilename
 */
const QString FileManager::getOriginalFilename()
{
    return filename;
}


/*!
    \fn FileManager::hasPrevious()
 */
bool FileManager::hasPrevious()
{
    return !iterator->atFirst();
}


/*!
    \fn FileManager::hasNext()
 */
bool FileManager::hasNext()
{
    return !iterator->atLast();
}

void FileManager::deleteAfterCurrent(){
        while(!iterator->atLast()){
            filenames.remove(iterator->operator++());
        }
}


/*!
    \fn FileManager::purgeTempDir()
 */
void FileManager::purgeTempDir()
{
    const QFileInfoList *list = tempDir->entryInfoList();
    QFileInfoListIterator it( *list );
    QFileInfo *fi;
    while ( (fi = it.current()) != 0 ) {
        tempDir->remove(fi->filePath());
        ++it;
    }
}


/*!
    \fn FileManager::getTempDir()
 */
QString FileManager::getTempDir()
{
    return tempDir->path();
}


/*!
    \fn FileManager::getFilenameExtension()
 */
QString FileManager::getFilenameExtension()
{
    QStringList list=QStringList::split(".",filename);
    return list.back();
}

/*!
    \fn FileManager::purgeDir(QString dir)
 */
void FileManager::purgeDir(QString dir)
{
    QDir removedir(dir);
    const QFileInfoList *list = removedir.entryInfoList();
    QFileInfoListIterator it( *list );
    QFileInfo *fi;
    while ( (fi = it.current()) != 0 ) {
        removedir.remove(fi->filePath());
        ++it;
    }
}


/*!
    \fn FileManager::deleteDir(QString dir)
 */
void FileManager::deleteDir(QString dirS)
{
    purgeDir(dirS);
    QDir dir(dirS);
    dir.rmdir(dirS);
}
