#!/usr/bin/python

# python xmlrpc client for freej 

# (C)2007 by Denis "Jaromil" Rojo

# GNU General Public License v3

# general system functions
import sys
from string import atoi

# xmlrpclib client functions
from socket import gethostname
from xmlrpclib import Transport, dumps





######################################################################
# XMLRPC Client connection class

class xmlrpc_connection:
    """The xmlrpc_connection class tests the xmlrpc_server.  You must 
    download and install the medusa and xmlrpclib libraries to run 
    this code:  http://www.nightmare.com  http://www.pythonware.com"""

    def __init__(self, host=None, port=2640):
        if host is None:
            host = gethostname()
        self.host = "%s:%s" % (host, port)
        print "Connecting to " + self.host
        self.transport = Transport()

    def remote(self, method, params=()):
        """remote invokes the server with the method name and an 
        optional set of parameters.  The return value is always a
        tuple."""
        print "sending command: " + method
        response = self.transport.request(self.host, 
                                          '/RPC2',
                                          dumps(params, method))
        return response

###################################################################





###################################################################
## MAIN



if __name__ == '__main__':

    commands = ("Exec")
    
    connection = xmlrpc_connection()

#    if(sys.argc):
#    	cmd = "none"
#    else:
    cmd = sys.argv[1]

    
    if not cmd in commands:

        print "no valid command recognized, list of valid commands:"
        print commands
        sys.exit(2)
        

    if cmd == "Exec":
        
        script = str( sys.argv[2] )

        (res,) = connection.remote(cmd, (script, 0))
        if res == 1:
            answer = "Script commands executed"
        else:
            answer = "Error executing command '" + cmd

    print answer # 42! ;D
