/***************************************************************************
 *   Copyright (C) 2004 by Nilesh Bansal                                   *
 *   nilesh@iitb.ac.in                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlcdnumber.h>
#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kglobal.h>
#include <qlayout.h>
#include <kiconloader.h>
#include <kaboutapplication.h>
#include <kaboutdata.h>
#include <kpopupmenu.h>
#include <kpassivepopup.h> 
#include <kconfigdata.h> 
#include <kdebug.h>
#include <ktextbrowser.h>
#include <qimage.h>
#include "ftpmonitor.h"
#include <qtooltip.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qstringlist.h>


#if KDE_IS_VERSION(3, 2, 0)
#include <kinputdialog.h> 
#else
#include <qinputdialog.h>
#endif



    FTPMonitor::FTPMonitor(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
: KPanelApplet(configFile, type, actions, parent, name)
{
    KGlobal::iconLoader()->addAppDir("ftpmonitor");	
    setBackgroundOrigin( AncestorOrigin );
    ksConfig = config();
    layout = new QVBoxLayout(this);


    number = 0;
    monitorLoop = new FTPMonitorLoop(3, this, (char *)"FTP Monitor Loop");
    if(ksConfig->readNumEntry("ftp_daemon",1)==1){
        monitorLoop->setPathPrivate(ksConfig->readEntry("pure-ftpwhopath",
                    "/usr/local/sbin/pure-ftpwho"));
        monitorLoop->ftpdaemon=1;	
        monitorLoop->useSudo=ksConfig->readNumEntry("pureftpd_use_sudo", 0);

    }else if(ksConfig->readNumEntry("ftp_daemon")==0){
        monitorLoop->setPathPrivate(ksConfig->readEntry("ncftpd_spypath",
                    "/usr/local/sbin/ncftpd_spy"));
        monitorLoop->ftpdaemon=0;
        monitorLoop->useSudo=ksConfig->readNumEntry("ncftpd_use_sudo", 1);
    }else if(ksConfig->readNumEntry("ftp_daemon")==3){
        monitorLoop->setPathPrivate(ksConfig->readEntry("proftpwhopath",
                    "/usr/bin/ftpwho"));
        monitorLoop->ftpdaemon=3;
        monitorLoop->useSudo=ksConfig->readNumEntry("proftpd_use_sudo", 0);

    }else{ //vsftpd
        monitorLoop->ftpdaemon=2;
        monitorLoop->useSudo=ksConfig->readNumEntry("vsftpd_use_sudo", 0);
    }
    monitorLoop->setInterval(1);
    notifyPopupTime=ksConfig->readNumEntry("notify_popup_time",1000);
    infoPopupTime = ksConfig->readNumEntry("info_popup_time",10000);
    popupEnable = ksConfig->readNumEntry("popup_enable",1);
    middleClickCommandSet = ksConfig->readNumEntry("middle_click_command_set",0);
    middleClickCommand = ksConfig->readEntry("middle_click_command","");

    connect	( monitorLoop,   SIGNAL(reverse()), this,      SLOT(slotReverse()) );

    QToolTip::add(this, i18n("FTP Monitor"));
    connect	( monitorLoop,   SIGNAL(change_in_conn()), this,      SLOT(slotChangeInConn())	);
    monitorLoop->start();
    monitorLoop->ftp_string = new QString(i18n("Nothing to Say"));

    popupmenu = new QPopupMenu(this,"FTP Monitor");
    popupmenu->insertItem(BarIcon("ftpmonitor-icon"),i18n("About FTP Monitor"), this, SLOT(showAbout()));
    popupmenu->insertItem(BarIcon("help"),i18n("Help"), this, SLOT(showHelp()));
    popupmenu->insertItem(BarIcon("configure"),i18n("Configure"), this, SLOT(showPrefs()));
    processIcons();	

}


FTPMonitor::~FTPMonitor()
{	
    delete monitorLoop;
    delete popupmenu;
    delete layout;
    //	delete paint;
}

void
FTPMonitor::showLog(){

}


void FTPMonitor::about()
{
    KAboutData about
        (
         "ftpmonitor",
         I18N_NOOP("FTP Monitor"),
         "0.80",
         I18N_NOOP("Keep watch on incoming connections to pure-ftpd/ncftpd/vsftpd/proftpd."),
         KAboutData::License_GPL_V2,
         "(C) 2005 Nilesh Bansal <nilesh@iitb.ac.in>",
         0,
         "http://www.cse.iitb.ac.in/nilesh/linux/ftpmonitor/" 
        );

    KAboutApplication a(&about, this);
    a.exec();

}


void FTPMonitor :: mousePressEvent(QMouseEvent *e)
{
    if (e->button() == RightButton)
        popupmenu->popup(e->globalPos());
    if (e->button() == MidButton){
        if((middleClickCommandSet) && !((middleClickCommand.stripWhiteSpace()).isEmpty() )){
            QProcess newProcess(this);
            QStringList commList = QStringList::split(" ",middleClickCommand);
            newProcess.setArguments(commList);
            newProcess.start(); 
        }
    }
    if (e->button() == LeftButton){
        slotClicked();
    }
}

void FTPMonitor :: changeToolTip()
{
    number = monitorLoop->no_of_connections;
    if(number > 0){
        if(number > 1){
            QToolTip::add(this, i18n("FTP Monitor - %1 connections").arg(number));
        }else{
            QToolTip::add(this, i18n("FTP Monitor - 1 connection"));
        }
    }else if(number == 0){
        QToolTip::add(this, i18n("FTP Monitor - No Connections"));
    }
}

void FTPMonitor::help()
{
    KMessageBox::information(0, 
            i18n("This is a small applet which monitors all incoming connections to ftpd (pure-ftpd/ncftpd/vsftpd/proftpd). If some one connects or disconnects it generates passive popups. Also you can click on it to find more info about active connections.\n\n For detailed help on using this applet please visit http://www.cse.iitb.ac.in/nilesh/linux/ftpmonitor/"));

}


void FTPMonitor::preferences()
{

    FTPConfig d
        (
         ksConfig,
         this,
         "FTP Monitor Configurations"
        );
    QDialog::DialogCode retval = QDialog::DialogCode(d.exec());	
    if (QDialog::Accepted == retval)
    {

        monitorLoop->setInterval(1);
        monitorLoop->ftpdaemon = d.ftpdaemonSelector_->currentItem();
        config()->writeEntry("ftp_daemon", d.ftpdaemonSelector_->currentItem(), true
                , true, false);
        monitorLoop->ftpdaemon = d.ftpdaemonSelector_->currentItem();
        if(d.popupEnableBox->isChecked()){
            popupEnable=1;	
            config()->writeEntry("popup_enable", 1, true, true, false);
            config()->writeEntry("notify_popup_time", 
                    (int)d.notifyInterval_->value(), true, true, false);
            notifyPopupTime = (int)d.notifyInterval_->value();

        }else{
            popupEnable=0;
            config()->writeEntry("popup_enable", 0, true, true, false);

        }
        if(monitorLoop->setPath(d.pathSelector_->url())){
            if(d.ftpdaemonSelector_->currentItem()==1)
                ksConfig->writeEntry("pure-ftpwhopath", d.pathSelector_->url(), true, true, false);		
            else if(d.ftpdaemonSelector_->currentItem()==0)
                ksConfig->writeEntry("ncftpd_spypath", d.pathSelector_->url(), true, true, false);
            else if(d.ftpdaemonSelector_->currentItem()==3)
                ksConfig->writeEntry("proftpwhopath", d.pathSelector_->url(), true, true, false);
            monitorLoop->setPathPrivate(d.pathSelector_->url());
        }
        if(d.useSudo_->isChecked())
            monitorLoop->useSudo = 1;
        else
            monitorLoop->useSudo = 0;


        if(d.ftpdaemonSelector_->currentItem() == 1){
            ksConfig->writeEntry("pureftpd_use_sudo", monitorLoop->useSudo,  true, true, false);
            if(monitorLoop->useSudo == 0)
                KMessageBox::information(0,
                        i18n("Make sure that file %1 is setuid so that \
                                    non-root user can execute it").arg(d.pathSelector_->url()));
            else
                KMessageBox::information(0, i18n("Make sure that %1 is in /etc/sudoers file").arg(d.pathSelector_->url()));
        }else if(d.ftpdaemonSelector_->currentItem() == 0){
            ksConfig->writeEntry("ncftpd_use_sudo", monitorLoop->useSudo,  true, true, false);
            KMessageBox::information(0,
                    i18n("As ncftpd_spy can be executed by root only, make sure that either you execute this applet as root or /etc/sudoers has following line \n\n username ALL=NOPASSWD: /usr/local/sbin/ncftpd_spy"));
        }else if(d.ftpdaemonSelector_->currentItem() == 2){
            ksConfig->writeEntry("vsftpd_use_sudo", monitorLoop->useSudo,  true, true, false);
            KMessageBox::information(0,i18n("Make sure that you set proctitle_enable=YES in vsftpd.conf"));
        }else if(d.ftpdaemonSelector_->currentItem() == 3){
            ksConfig->writeEntry("proftpd_use_sudo", monitorLoop->useSudo,  true, true, false);
        }


        if (d.middleMouseClickSet_->isChecked()){
            middleClickCommandSet=1;
            middleClickCommand = d.middleMouseClick_->text();
            config()->writeEntry("middle_click_command",middleClickCommand, true, true, false);
        }else{ 
            middleClickCommandSet=0;
        }
        config()->writeEntry("middle_click_command_set", middleClickCommandSet, true, true, false);
        processIcons();

        infoPopupTime = (int)d.infoPopupTime_->value();
        config()->writeEntry("info_popup_time", infoPopupTime, true, true, false);		

        ksConfig->sync();


    }		

}

int
FTPMonitor::widthForHeight(int height) const 
{
    return 24;
}

int
FTPMonitor::heightForWidth(int width) const
{
    return 24;
}


void FTPMonitor::resizeEvent(QResizeEvent *e)
{
    //do nothing
}

    void
FTPMonitor::processIcons()
{
    iconConnected = QPixmap(BarIcon("ftpmonitor-connected"));
    iconIdle = QPixmap(BarIcon("ftpmonitor-idle"));
    QImage qi1, qi2;
    qi1 = iconConnected.convertToImage();
    qi2 = iconIdle.convertToImage();
    if (qi1.hasAlphaBuffer())
        bitmapConnected = qi1.createAlphaMask();
    else
        bitmapConnected = QBitmap();
    if (qi1.hasAlphaBuffer())
        bitmapIdle = qi2.createAlphaMask(); 
    else
        bitmapIdle = QBitmap();
    repaint();
}


void FTPMonitor::slotClicked()
{	
    KPassivePopup::message( i18n("FTP Monitor"), *monitorLoop->ftp_string, 
            BarIcon("ftpmonitor-icon"), this, 0L, infoPopupTime );
}

void FTPMonitor::slotChangeInConn()
{	
    QPixmap px;
    px.load( "ftpmonitor-connected.png" );
    QString conn_string = "";
    conn_string += QString::number(monitorLoop->no_of_connections);
    if(number > 1)
        conn_string.append(i18n(" connections"));
    else
        conn_string.append(i18n(" connection"));
    if(popupEnable)
        KPassivePopup::message( i18n("FTP Monitor"), conn_string,
                0 , this, 0L, notifyPopupTime ); 
    //We will not have a icon in popup here, it dont look nice.		              
    changeToolTip();


}


void FTPMonitor::slotReverse()
{
    number = monitorLoop->no_of_connections;
    repaint();
    //	showIcon();
}

void FTPMonitor::showPrefs()
{
    preferences();
}

void FTPMonitor::showAbout()
{
    about();
}
void FTPMonitor::showHelp()
{
    help();
}


extern "C"
{
    KPanelApplet* init( QWidget *parent, const QString configFile)
    {
        KGlobal::locale()->insertCatalogue("ftpmonitor");
        return new FTPMonitor(configFile, KPanelApplet::Normal,
                KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                parent, "ftpmonitor");
    }
}

void
FTPMonitor::paintEvent(QPaintEvent * e){
    QPainter paint(this);
    paint.begin( this );
    int xPos = (width() - 24)/2 + 2;
    int yPos = (height() - 24)/2 + 2;
//  kdDebug() << "xPos:yPos = " << xPos << ":" << yPos << "\n";
    if(number){
        paint.drawPixmap(xPos,yPos,iconConnected);
    }else{
        paint.drawPixmap(xPos,yPos,iconIdle);
    }
    paint.end();
}
