#! /usr/bin/python

from distutils.core import setup, Extension
import commands, os


# fusd's build process puts the library in a directory that depends upon the
# host system's 'uname' output
cpu_name = commands.getoutput("uname -m")
os_name = commands.getoutput("uname -s | tr '[A-Z]' '[a-z]'")
archdir = "../obj.%s-%s" % (cpu_name, os_name)

# if we are building in fusd/python/, get the include file and library from
# the local tree. If not, hope that they've been installed into /usr/include
# and /usr/lib or somewhere else on the compiler's search path.

library_dirs = []
if os.path.isdir(archdir):
    library_dirs = [archdir]
include_dirs = []
if os.path.isdir("../include"):
    include_dirs = ["../include"]

setup(name="fusd",
      version="1",
      description="interface to FUSD (linux user-space device drivers)",

      py_modules = ['fusd'],
      ext_modules=[ Extension("_fusd", ["fusdmodule.c"],
                              include_dirs=include_dirs,
                              libraries=["fusd"],
                              library_dirs=library_dirs,
                              )
                    ],
      )
