# First draft 02/06/97    Jianjun
#constrct a FitsExtension class to let header and table share one FitsFileObj
# FitsExtension fMode chdu fileName father header/data

class FitsExtension {

    public method dispHeader {}
    public method dispTable  { {content {}} forceNew }
    public method plotData   { {params  {}} }
    public method addChild   { child type }
    public method freeChild  { child }
    public method updateHL   { field value }
    public method updateDisps { child }
    public method setFileName { fName }
    public method closeCmd   { }

    private method getImageSlice { numSlices }
    private method getTableSlice { numSlices }

    public variable fFObj

    private variable myHeader {}
    private variable myTables {}
    private variable father
    private variable chdu

    # These are scratch variables for handling 3D images
    private variable itype
    private variable istart
    private variable iend
    private variable islice
    private method setIType { type }

    constructor {args} {}
    destructor         {}
    
}

body FitsExtension::constructor {args} {
    set fMode     [lindex $args 0] 
    set chdu      [lindex $args 1]
    set fileName  [lindex $args 2]
    set father    [lindex $args 3]

    if { $fMode==1 } {
	set fFObj [FitsFile #auto $fileName $fMode $father]
    } else {
	if { [file writable $fileName] } {
	    set fFObj [FitsFile #auto $fileName $fMode $father]
        } else {
            set fFObj [FitsFile #auto $fileName 1 $father]
	}
    }

    $fFObj move $chdu
    $father addChild $this $chdu
}

body FitsExtension::destructor {} {
   delete object $fFObj
   $father freeChild $chdu
}

body FitsExtension::dispHeader {} {

   set fH $myHeader
   if { $fH=="" } {
      set fH [namespace current]::[FitsHeader #auto $fFObj $this]
      $fH makeHeader
   } else {
      $fH bringToFront
   }
   return $fH
}

body FitsExtension::dispTable { {content {}} forceNew } {

   set oneRaised 0
   if { ! $forceNew } {
      foreach fT $myTables {
         if { [$fT bringToFront] } {
            set oneRaised 1
         }
      }
   }
         
   set type [lindex [$fFObj getTabInfo hdutype] 1]
   if { $type=="Table" } {

      if { $forceNew || !$oneRaised } {
         set fT [FitsTable #auto $fFObj $this]
         set fT [namespace current]::$fT
         if { !$forceNew && [llength $content]==0 } {
            set content "-"
         }
         $fT dispTable $content
      }

   } else {

      if { $forceNew || !$oneRaised } {
         set imgdim [$fFObj getImgInfo]
         if { [llength $imgdim] > 2 && [lindex $imgdim 2] > 1} {
            if { [llength $content]==1 || [llength $content]==3 } {
               set islice [lindex $content end]
            } else {
               getTableSlice [lindex $imgdim 2]
            }
            if { $islice<1 || $islice>[lindex $imgdim 2] } return
            set fT [CubeImage #auto $fFObj $this $islice $islice]
            set fT [namespace current]::$fT
            $fT makeTable
         } else {
            set fT [FitsImage #auto $fFObj $this]
            set fT [namespace current]::$fT
            $fT makeTable
         }
      } else {
         set fT [lindex $myTables 0]
      }

      if { [llength $content]>1 } {
         # Highlight the indicated pixel
         update idletask
         $fT showCell [lindex $content 0] [lindex $content 1]
      }

   }

   return $fT
}


body FitsExtension::plotData { {params {}} } {

   set type [lindex [$fFObj getTabInfo hdutype] 1]
   if { $type=="Table" } {

      set fT [FitsTable #auto $fFObj $this]
      $fT scplotCmd $params 

   } else {

      set imgdim [$fFObj getImgInfo]
      if { [llength $imgdim] > 2 && [lindex $imgdim 2] > 1 } {
         if { [llength $params]==0 } {
            getImageSlice [lindex $imgdim 2]
         } elseif { [llength $params]==1 } {
            set istart $params
            set iend   $params
            set itype  "Animate"
         } else {
            set istart [lindex $params 0]
            set iend   [lindex $params 1]
            set itype  "Animate"
         }
         switch $itype {
            "Mosaic" {
               # Not enabled
               set fI [FitsImage  #auto $fFObj $this]
            }
            "WFPC" { 
               set fI [WFPC2Image #auto $fFObj $this]
            }
            "Animate" {
               set fI [CubeImage  #auto $fFObj $this $istart $iend]
            }
            default {
               return
            }
         }
      } else {
         set fI [FitsImage #auto $fFObj $this]
      }
      if { [lindex $params 0] == "-rows" || [lindex $params 0] == "-cols" } {
         set inCurrgn 0
         set crvType [string range [lindex $params 0] 1 3]

         if { [llength $params]==1 } {
            error "Usage: display curve extNum -rows|-cols start ?end? ?currGraph?"
         } elseif { [llength $params]==2 } {
            set istart [lindex $params 1]
            set iend   $istart
         } elseif { [llength $params]==3 } {
            set istart [lindex $params 1]
            set iend   [lindex $params 2]
         } else {
            set istart [lindex $params 1]
            set iend   [lindex $params 2]
            set inCurrgn [lindex $params 3]
         }
         $fI imagePlot [list $crvType $istart $iend $inCurrgn]
      } else {
         $fI makeImage
      }

   }
}

body FitsExtension::getImageSlice { numSlices } {
   # Sets 'itype' to the image type to display, and 'istart/iend' if
   # an animation is desired.  'itype' will be "" if canceled

   set istart 1
   set islice 1
   set iend   $numSlices
   set itype  ""

   if { [catch {set instName [$fFObj getKeyword "INSTRUME"]} ] == 0 } {
      set instName [string range [string trim [lindex \
            [join $instName] 1] "' "] 0 3] 
   } else {
      set instName ""
   }
   
   # image selection
   if { [winfo exist .fv_imgsel] == 1 } {
      destroy .fv_imgsel
   }
   powToplevel  .fv_imgsel .dummy
   wm title     .fv_imgsel "fv: Image Selection"
   
   if { $instName == "WFPC"} {
      label .fv_imgsel.label -text "This is an HST/WFPC image"  \
            -relief ridge -borderwidth 4
      button .fv_imgsel.mosaic -text "WFPC" \
            -command "[code $this setIType WFPC]
                      destroy .fv_imgsel"
   } else {
      label .fv_imgsel.label -text "The image has $numSlices slices" \
            -relief ridge -borderwidth 4
      button .fv_imgsel.mosaic -text "Mosaic" \
            -command "[code $this setIType MOSAIC]
                      destroy .fv_imgsel" \
            -state disabled
   }
   label .fv_imgsel.sl  -width  5  -text "Start"
   entry .fv_imgsel.se  -width 10  -textvariable [scope istart]
   label .fv_imgsel.el  -width  5  -text "End"
   entry .fv_imgsel.ee  -width 10  -textvariable [scope iend]
   
   button .fv_imgsel.anim -text "Animate" \
         -command "[code $this setIType Animate]
                   destroy .fv_imgsel"
   button .fv_imgsel.cancel -text "Cancel" \
         -command "destroy .fv_imgsel"
   button .fv_imgsel.help -text "Help" \
         -command "hhelp 3D-ImageDisplay"


   grid .fv_imgsel.label  -column 0 -row 0  -columnspan 4 -sticky "snew"
   grid .fv_imgsel.sl     -column 0 -row 1 
   grid .fv_imgsel.se     -column 1 -row 1 
   grid .fv_imgsel.el     -column 2 -row 1 
   grid .fv_imgsel.ee     -column 3 -row 1 
   grid .fv_imgsel.anim   -column 0 -row 2 
   grid .fv_imgsel.mosaic -column 1 -row 2 
   grid .fv_imgsel.cancel -column 2 -row 2 
   grid .fv_imgsel.help   -column 3 -row 2 
   
   tkwait window .fv_imgsel
}


body FitsExtension::getTableSlice { numSlices } {
   # Sets 'islice' to the image slice to display, or -1 if canceled

   set istart 1
   set islice 1
   set iend   $numSlices
   set itype  ""

   # image selection
   if { [winfo exist .fv_imgsel] } {
      destroy .fv_imgsel
   }
   powToplevel  .fv_imgsel .dummy
   wm title     .fv_imgsel "fv: Image Selection"
   
   label .fv_imgsel.label -text "The image has $numSlices slices" \
         -relief ridge -borderwidth 4
   
   label .fv_imgsel.sl   -width  5  -text "Slice"
   entry .fv_imgsel.se   -width 10  -textvariable [scope islice]
   bind .fv_imgsel.se <Return> "[code $this setIType Slice]
                                destroy .fv_imgsel"
   
   button .fv_imgsel.display -text "Display" \
         -command "[code $this setIType Slice]
                   destroy .fv_imgsel"
   button .fv_imgsel.cancel -text "Cancel" \
         -command "destroy .fv_imgsel"
   button .fv_imgsel.help -text "Help" \
         -command "hhelp 3D-ImageTable"


   grid .fv_imgsel.label   -column 0 -row 0  -columnspan 4 -sticky "snew"
   grid .fv_imgsel.sl      -column 0 -row 1 
   grid .fv_imgsel.se      -column 1 -row 1 
   grid .fv_imgsel.display -column 0 -row 2 
   grid .fv_imgsel.cancel  -column 1 -row 2 
   grid .fv_imgsel.help    -column 2 -row 2 
   
   tkwait window .fv_imgsel
   
   if { $itype == "" } {
      set islice -1
   }
}

body FitsExtension::setIType { type } {
   set itype $type
}


body FitsExtension::addChild { child type } {
   if { $type=="header" } {
      if { [llength $myHeader]==0 } {
         set myHeader $child
      } else {
         puts "myHeader already has value $myHeader"
      }
   } elseif { $type=="table" } {
      lappend myTables $child
   }
}


body FitsExtension::freeChild { child } {

   if { $child==$myHeader } {
      set myHeader {}
   } else {
      set pos [lsearch $myTables $child]
      if { $pos!=-1 } {
         set myTables [lreplace $myTables $pos $pos]
      } else {
         puts "Unable to find child $child"
      }
   }

   if { [llength $myHeader]==0 && [llength $myTables]==0 } {
      delete object $this
   }
}

body FitsExtension::updateHL { field value } {
   $father updateHighLight $chdu $field $value
}

body FitsExtension::updateDisps { child } {
   foreach head $myHeader {
      if { $child!=$head } {$myHeader refresh}
   }
   foreach table $myTables {
      if { $child!=$table } {$table refresh}
   }
}

body FitsExtension::setFileName { fName } {
   foreach head $myHeader {
      $myHeader setFileName $fName
   }
   foreach table $myTables {
      $table setFileName $fName
   }
}

body FitsExtension::closeCmd { } {
   foreach head $myHeader {
      $myHeader closeCmd
   }
   foreach table $myTables {
      $table closeCmd
   }
}
