/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* gul-bonobo-extensions.h - interface for new functions that conceptually
                             belong in bonobo. Perhaps some of these will be
                             actually rolled into bonobo someday.


            This file is based on nautilus-bonobo-extensions.h from
            libnautilus-private.


   Copyright (C) 2000 Eazel, Inc.

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: John Sullivan <sullivan@eazel.com>
*/

#ifndef GUL_BONOBO_EXTENSIONS_H
#define GUL_BONOBO_EXTENSIONS_H

#include <bonobo/bonobo-ui-component.h>
#include <bonobo/bonobo-control.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtkwidget.h>

void		gul_bonobo_set_accelerator                   	(BonoboUIComponent *ui,
								 const char *path,
								 const char *accelerator);
void		gul_bonobo_set_label                           	(BonoboUIComponent *ui,
								 const char *path,
								 const char *label);
void		gul_bonobo_set_tip                             	(BonoboUIComponent *ui,
								 const char *path,
								 const char *tip);
void		gul_bonobo_set_hidden                          	(BonoboUIComponent *ui,
								 const char *path,
								 gboolean hidden);
void		gul_bonobo_add_numbered_menu_item              	(BonoboUIComponent *ui,
								 const char *container_path,
								 guint index,
								 const char *label,
								 GdkPixbuf *pixbuf);
char *		gul_bonobo_get_numbered_menu_item_command      	(BonoboUIComponent *ui,
								 const char *container_path,
								 guint  index);
char *		gul_bonobo_get_numbered_menu_item_path         	(BonoboUIComponent *ui,
								 const char *container_path,
								 guint index);
void 		gul_bonobo_clear_path				(BonoboUIComponent *uic,
								 const gchar *path);
void 		gul_bonobo_replace_path				(BonoboUIComponent *uic,
								 const gchar *path_src, 
								 const char *path_dst);

#endif /* GUL_BONOBO_EXTENSIONS_H */
