#ifndef METRIC_TYPEDEFS_H
#define METRIC_TYPEDEFS_H 1
#include "gangliaconf.h"

typedef enum {
   g_string,  /* huh uh.. he said g string */
   g_int8,
   g_uint8,
   g_int16,
   g_uint16,
   g_int32,
   g_uint32,
   g_float,
   g_double,
   g_timestamp    /* a uint32 */
} g_type_t;
 
#define MAX_G_STRING_SIZE 32
 
typedef union {
    int8_t   int8;
   uint8_t  uint8;
   int16_t  int16;
  uint16_t uint16;
   int32_t  int32;
  uint32_t uint32;
   float   f; 
   double  d;
   char str[MAX_G_STRING_SIZE];
} g_val_t;         

typedef g_val_t (*metric_func)(void); 

/*
 * Each host parameter is assigned it's own metric_t structure.  This
 * structure is used by both the monitoring and multicasting threads.
 */
typedef struct
{
   const char name[16];          /* the name of the metric */
   metric_func func; 
   int check_threshold;
   int mcast_threshold;
   g_val_t now;
   g_val_t last_mcast;     /* the value at last multicast */
   int value_threshold; 
   int check_min;          /* check_min and check_max define a range of secs */
   int check_max;          /*    which pass between each /proc check for the metric */
   int mcast_min;          /* mcast_min and mcast_max define a range of secs */
   int mcast_max;          /*    which a mcast of the metric is forced */
   g_type_t type;          /* type of data in our union */
   char units[32];         /* units the value are in */
   char fmt[16];           /* how to format the binary to a human-readable string */
}
metric_t;          

#endif
