#!/usr/bin/env python2.4

import pygtk
pygtk.require('2.0')
import gobject
import gtk
import sys
import subprocess
import apt_pkg
import tempfile

import utils

from gettext import gettext as _
from UpdateManager.Common.SimpleGladeApp import SimpleGladeApp
from softwareproperties.gtk.DialogAptKey import DialogAddKey as apt_key
from aptsources.sourceslist import SourceEntry, SourcesList

from gapti.SoftwarePackageWindow import SoftwarePackageWindow

class GAptIRoot:
    """Portion of GAptI which requiest root access."""

    def __init__(self, datadir=None, parent=None):  

        if (datadir == None):
            datadir = '/usr/share/gapti/'
        self.datadir = datadir

        # Continue processing on the main loop.
        gobject.timeout_add(0, self.main)
        
    def main(self):
        """Invoked on main loop."""
        if not self.run():
            gtk.main_quit()
        return False
        
    def run(self):
        """Does actual work."""
        
        # Program requires three files. First is the keys file to import.
        # Second is a flat list of sources.list lines to be appended. Third is
        # a simple list of packages seperated by whitespace.
        
        if (len(sys.argv) != 4):
            utils.dialog_error(None, 'GApti Error', 'Exactly three arguments must be passed to gapti-root.')
            return
        
        keys_file = sys.argv[1]
        archives_file = sys.argv[2]
        packages_file = sys.argv[3]
        
        if (not self.add_keys(keys_file)):
            return False
            
        if (not self.add_archives(archives_file)):
            return False
        
        if (not self.update_cache()):
            return False
        
        if (not self.select_packages(packages_file)):
            return False
        
        return True
        
    def add_keys(self, filename):
        """Imports the specified filename with apt-key."""
        ak = apt_key()
        if (not ak.add(filename)):
            utils.dialog_error(None, 'GAptI Error', 'Unable to import keys.')
            return False
        else:
            return True
            
    def add_archives(self, archives_file):
        """Appends the specified archives to the apt sources."""
        
        # Load the existing sources file.
        apt_dir = '/etc/apt/'
        apt_file = 'sources.list'
        apt_path = apt_dir + apt_file
        apt_pkg.Config.Set('Dir::Etc', apt_dir)
        apt_pkg.Config.Set('Dir::Etc::sourcelist', apt_file)
        old_sources = SourcesList()
        old_sources.refresh()
        
        # Load the sources file containing entries to be added.
        new_sources = utils.GAptISourcesList()
        new_sources.load(archives_file)
        
        # Add each new to the old.
        for source in new_sources.list:
            old_sources.add(source.type, source.uri, source.dist, source.comps, pos=len(old_sources.list))
        for source in old_sources.list:
            source.file = apt_path
            
        old_sources.save()
        
        return True
    
    def update_cache(self):
        cmd = ['/usr/sbin/synaptic',
               '--hide-main-window', '--non-interactive',
               '--update-at-startup' ]
        p = subprocess.Popen(cmd)
        if (p.wait() != 0):
            return False
        
        return True
    
    def select_packages(self, packages_file):
        pkgs = []
        lines = open(packages_file, 'r').readlines()
        for line in lines:
            pkg = line.strip().split(' ')[0]
            pkgs.append(pkg)
            
        self.package_window = SoftwarePackageWindow('%s/gapti.glade' % self.datadir)
        self.package_window.set_packages(pkgs)    
        self.package_window.show()
        
        self.package_window.help_button.connect('clicked', self.help_button_clicked)
        self.package_window.cancel_button.connect('clicked', self.cancel_button_clicked)
        self.package_window.install_button.connect('clicked', self.install_button_clicked)
        
        return True
    
    def help_button_clicked(self, user_data):
        return
    
    def cancel_button_clicked(self, user_data):
        return
    
    def install_button_clicked(self, user_data):
        packages = self.package_window.get_package_selections()
        pkg_tmp = tempfile.NamedTemporaryFile()
        for package in packages:
            print '%s install' % package
            pkg_tmp.write('%s install\n' % package)
            
        pkg_tmp.flush()
        self.install(pkg_tmp.name)
        pkg_tmp.close()

    def install(self, packages_file):
        cmd = ['/usr/sbin/synaptic', '--hide-main-window', '--non-interactive',
               '--progress-str', 'Please wait, this can take some time.',
               '--finish-str', 'Installation is complete.',
               '--set-selections-file', packages_file]
        print cmd
        p = subprocess.Popen(cmd)
        p.wait()
        gtk.main_quit()
            
if __name__ == '__main__':
    gapti = GAptIRoot()
    gtk.main()
