/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_SOUND_C 1

#include "gatos.h"
#include "sound.h"
#include "board.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>

static int setmixer=0 ;

/* ------------------------------------------------------------------------ */
/* Initialization routine */

/* Initialize sound, disable audio ioctl's if any errors */
int sound_init(void) {
  int i ;

#ifdef NEWSOUNDMIXER
  sound_filter_mixers();
#endif /* NEWSOUNDMIXER */

  if(gatos.audiotype&SNDCARD_MIXER) {
    /* Open mixer device */
    gatos.mixerfd = open("/dev/mixer", 0) ;
    if(gatos.mixerfd<0) perror("GATOS: open(/dev/mixer) failed") ;
    /* Default to line-in */
    gatos.mixerdev = -1 ;
    if(gatos.mixerfd>=0)

#ifdef NEWSOUNDMIXER
      for(i=0; i<GATOS_MIXER_NRDEVICES; i++)
	if(!strcmp("line",gatos_mixer_names[i])) 
	  gatos.mixerdev = gatos_mixernum[i] ;
#else
    for(i=0; i<SOUND_MIXER_NRDEVICES; i++)
      if(!strcmp("line",mixer_names[i])) gatos.mixerdev = i ;
#endif /* NEWSOUNDMIXER */

     /* Disable audio if open failed, line-in not found or read failed */
    if(gatos.mixerdev<0 
        || ioctl(gatos.mixerfd, MIXER_READ(gatos.mixerdev), &gatos.oldvol)) {
      if(gatos.mixerfd>=0) perror("GATOS: mixer read failed") ;
      gatos.audiotype &= DISABLE_MIXER ; 
      }
    }
  if(gatos.audiotype==BRDCARD_MIXER) {
    gatos_setvolume(gatos.volume);
    }

  RETURN0 ; 
  }

/* ------------------------------------------------------------------------ */
/* Public routines */

int sound_restore(void) {
  if(gatos.audiotype&SNDCARD_MIXER) {
    ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev), &gatos.oldvol) ;
    }
  if(gatos.audiotype&BRDCARD_MIXER) {
    /*board_setvol(gatos.oldvol);*/
    }

  RETURN0 ; 
  }

int sound_setvol(int value) {
  if(gatos.audiotype&SNDCARD_MIXER && setmixer) {
    value |= value<<8 ;
    if(ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev), &value) == -1) { 
      perror("GATOS: volume set failed") ; 
      gatos.audiotype &= DISABLE_MIXER ; 
      }
    }
  if(gatos.audiotype&BRDCARD_MIXER) {
    /*board_setvol(value);*/
    }

  RETURN0 ;
  }

int sound_setmixer(int value) {
  /*if (!(gatos.audiotype&SNDCARD_MIXER)) RETURN0 ;
    if (setmixer && (ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev),
    &gatos.oldvol) == -1)) RETURN(errno) ;*/

#ifdef NEWSOUNDMIXER
  gatos.mixerdev = gatos_mixernum[sound_getfiltnummixer(value)] ; 
#else
  gatos.mixerdev = value ;  
#endif /* NEWSOUNDMIXER */

  setmixer = 1 ;

  if(gatos.mixerfd>=0 
      && ioctl(gatos.mixerfd, MIXER_READ(gatos.mixerdev), &gatos.oldvol)) { 
    perror("GATOS: mixer set failed") ;  
    gatos.audiotype &= DISABLE_MIXER ; 
    }
  else 
    gatos.audiotype |= SNDCARD_MIXER;
  
  RETURN0 ; 
  }

int sound_nummixers() {
  /*if (!(gatos.audiotype&SNDCARD_MIXER)) RETURN0 ;*/
  if(gatos.mixerfd <= 0) {
    RETURN0;
    } 
  else {

#ifdef NEWSOUNDMIXER
    return GATOS_MIXER_NRDEVICES;
#else
    return SOUND_MIXER_NRDEVICES;
#endif /* NEWSOUNDMIXER */

    }
  }

char* sound_mixername(int value) {

#ifdef NEWSOUNDMIXER
  return gatos_mixer_names[value];
#else
  return mixer_names[value];
#endif /* NEWSOUNDMIXER */

  }

char** sound_mixernames() {

#ifdef NEWSOUNDMIXER
  return gatos_mixer_names;
#else
  return mixer_names;
#endif /* NEWSOUNDMIXER */

  }

char** sound_mixerlabels() {

#ifdef NEWSOUNDMIXER
  return gatos_mixer_labels;
#else
  return mixer_labels;
#endif /* NEWSOUNDMIXER */

  }


#ifdef NEWSOUNDMIXER
/* 
 * Mixers names filtering.
 */
void sound_filter_mixers(void) {
  int i, f, mixnum, badmix;

  mixnum=0;
  for(i=0; i<SOUND_MIXER_NRDEVICES; i++) {
    badmix=1;
    for(f=0; f<MIXER_FILTER_NRDEVICES; f++) {
      if(!strcmp(mixer_names[i], mixer_filter_names[f])) {
	badmix=1;
	f=MIXER_FILTER_NRDEVICES;
        } 
      else {
	badmix=0;
        }
      }
    if(badmix==0) {
      gatos_mixer_names[mixnum]=mixer_names[i]; 
      gatos_mixer_labels[mixnum]=mixer_labels[i];
      gatos_mixernum[mixnum]=i;
      mixnum++; 
      } 
    }
  }

/* 
 * Return the place where real mixer number is stored
 * in gatos_mixernum array.
 *
 * value: real mixer number
 * returned value: array position of real mixer number
 * If real mixer not found in gatos_mixernum, it return 0.
 */
int sound_getfiltnummixer(int value) {
  int i;

  for(i=0; i<GATOS_MIXER_NRDEVICES; i++)
    if(value == gatos_mixernum[i]) {
      return i;
      }

  RETURN0;
  }

#endif /* NEWSOUNDMIXER */
