/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

extern char global_domain_name[1024];
extern char global_domain_address[1024];
extern char global_domain_type[1024];



void select_first_domain(struct w *widgets)
{
    GtkTreePath *path;
    GtkTreeIter iter;
    GtkTreeModel *list_store;
    gchar *domain=NULL, *address=NULL, *type=NULL;

    path = gtk_tree_path_new_first();

    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(widgets->domain_treeview));

    if( ! gtk_tree_model_get_iter(list_store, &iter, path) )
    {
       gtk_tree_path_free(path);
       return;
    }
    
    gtk_tree_model_get(list_store, &iter, 0, &domain, -1);
    gtk_tree_model_get(list_store, &iter, 1, &address, -1);
    gtk_tree_model_get(list_store, &iter, 2, &type, -1);

    if( domain==NULL || address==NULL || type==NULL )
    {
        gtk_tree_path_free(path);
        return;
    }

    sprintf(global_domain_name, "%s", (gchar *)domain);
    sprintf(global_domain_address, "%s", (gchar *)address);
    sprintf(global_domain_type, "%s", (gchar *)type);

    g_free(domain);
    g_free(address);
    g_free(type);
}
