from libdesklets.controls import Control, Interface, Permission

from ImondConnection import *
import time

class IImonc(Interface):

	# connection settings
	i_hostname 	= Permission.READWRITE
	i_port		= Permission.READWRITE
	i_password	= Permission.WRITE

	i_status		= Permission.READ

	# fli4l status data
	hostname	= Permission.READ
	version		= Permission.READ
	fli4l_version	= Permission.READ
	imond_version = Permission.READ
	uptime		= Permission.READ
	date			= Permission.READ
	cpu			= Permission.READ

	# device stats
	status		= Permission.READ
	phone		= Permission.READ
	ip			= Permission.READ
	inout		= Permission.READ
	rate			= Permission.READ
	quantity		= Permission.READ
	online_time	= Permission.READ
	time			= Permission.READ
	charge_time	= Permission.READ
	charge		= Permission.READ

	# error handling
	err			= Permission.READ

class Imonc(Control, IImonc):

	def __init__(self):
		self.con = None

		self._i_hostname 	= "fli4l"
		self._i_port 		= 5000
		self._i_password 	= ""

		self._i_status		= "unknown"

		self._err			= ""

		# call constructor of super class
		Control.__init__(self)

		# try to connect
		self.__connect_new()

	def _shutdown(self):
		if (self.con != None):
			self.con.disconnect()

	def __connect_new(self):
		if (self.con != None and self.con.connected()):
			self.con.disconnect()
		self.con = ImondConnection(self._i_hostname,self._i_port,self._i_password)
		# try to connect
		try:
			self.con.connect()
			self._i_status = "connected"
		except ImondConnectionError, e:
			print "an error occured connecting: " + e.err
			self._i_status = "error"
			self._err = e.err
		self._update("i_status")

	# getters
	def __get_i_hostname(self):	return self._i_hostname
	def __get_i_port(self):		return int(self._i_port)

	def __get_i_status(self):	return self._i_status

	# remote state
	def __get_hostname(self): 	return self.con.get_hostname()
	def __get_version(self):		return self.con.get_version()
	def __get_fli4l_version(self):	return self.con.get_fli4l_version()
	def __get_imond_version(self): return self.con.get_imond_version()
	def __get_cpu(self):		return self.con.get_cpu()
	def __get_uptime(self):		return self.con.get_uptime()
	def __get_date(self):		return self.con.get_date()

	# device stats
	def __get_status(self):		return self.con.get_status()
	def __get_phone(self):		return self.con.get_phone()
	def __get_inout(self):		return self.con.get_inout()
	def __get_ip(self):			return self.con.get_ip()
	def __get_rate(self):		return self.con.get_rate()
	def __get_quantity(self):	return self.con.get_quantity()
	def __get_online_time(self):	return self.con.get_online_time()
	def __get_time(self):		return self.con.get_time()
	def __get_charge_time(self): return self.con.get_charge_time()
	def __get_charge(self):		return self.con.get_charge()

	# get error
	def __get_err(self):		return self._err

	# setters
	def __set_i_hostname(self, val): 	
		self._i_hostname = val
		self.__connect_new()
	def __set_i_port(self,val):
		self._i_port = val
		self.__connect_new()
	def __set_i_password(self,val):
		self._i_password = val
		self.__connect_new()

	i_hostname 	= property(__get_i_hostname, __set_i_hostname, doc = "hostname to connect to")
	i_port		= property(__get_i_port, __set_i_port, doc = "remote port to connect to")
	i_password	= property(fset = __set_i_password, doc = "password to be used if required")

	i_status		= property(__get_i_status, doc = "status of connection to remote host")

	hostname 	= property(__get_hostname, doc = "remote hostname")
	fli4l_version	= property(__get_fli4l_version, doc = "remote fli4l version")
	imond_version	= property(__get_imond_version, doc = "remote imond version")
	version		= property(__get_version, doc = "remote version information")
	uptime		= property(__get_uptime, doc = "remote uptime in seconds")
	date			= property(__get_date, doc = "remote system time and date")
	cpu			= property(__get_cpu, doc = "remote CPU usage")
	
	status		= property(__get_status, doc = "state of channel e.g. 'Online','Offline'")
	phone		= property(__get_phone, doc = "phone number/name of circuit")
	inout		= property(__get_inout, doc = "direction of channel")
	ip			= property(__get_ip, doc = "ip of channel")
	rate			= property(__get_rate, doc = "rate of channel as tuple (in, out)")
	quantity		= property(__get_quantity, doc = "transfered data quantity of channel. imond version > 10 has a 4-tuple of (inh, inl, outh, outl), prior version had a tuple of (in, out)")
	online_time	= property(__get_online_time, doc = "current online time for channel")
	time			= property(__get_time, doc = "sum of online times for channel")
	charge_time	= property(__get_charge_time, doc = "charge time")
	charge		= property(__get_charge, doc = "charge amount")

	err			= property(__get_err, doc = "error message if sth. went wrong")

def get_class(): return Imonc
