# -*- coding: UTF-8 -*-
from libdesklets.controls import Control

from ISytadin import ISytadin

import commands
import re
import os
import time
import urllib

#
# Control for Sytadin - Paris/Ile de France traffic information
#
class Sytadin(Control, ISytadin):

	def __init__(self):
	
		# Default values
		self.__start = "Start point"
		self.__dest = "Destination point"
		self.__interv = 300000
		self.__time = "Error"
		self.__dist = "Error"
		self.__fiab = "Error"
		self.__traffic = 0
	
		Control.__init__(self)
		
		interv = self.__get_interv()
		
		self.__id_timer = self._add_timer(interv, self.__get_values)
	
	def __get_start(self):
	
		return self.__start.decode('utf8')
	
	def __set_start(self, st):

		self.__start = st
		self._update("start")
		self._remove_timer(self.__id_timer)
		self.__get_values()

	def __get_dest(self):
	
		return self.__dest.decode('utf8')
	
	def __set_dest(self, dst):

		self.__dest = dst
		self._update("dest")
		self._remove_timer(self.__id_timer)
		self.__get_values()
	
	def __get_time(self):

		return self.__time
	
	def __get_dist(self):

		return self.__dist
	
	def __get_fiab(self):

		return self.__fiab

	def __get_interv(self):

		return self.__interv

	def __set_interv(self, intrv):

		self.__interv = intrv * 60000
		self._remove_timer(self.__id_timer)
		interv = self.__get_interv()
		self.__id_timer = self._add_timer(interv,self.__get_values)
	
	def __get_traffic(self):
		
		return self.__traffic
	
	def __get_values(self):

		start = self.__get_start()
		dest = self.__get_dest()
		interv = self.__get_interv()

		if ((start != "Start point") and (dest != "Destination point")):
			web_start = urllib.quote(start)
			web_dest = urllib.quote(dest)
		
			params = "depart=%(web_start)s&arrivee=%(web_dest)s" % vars()
			fh = urllib.urlopen("http://www.sytadin.tm.fr/cgi-bin/cltcgi_calcul", params)
			data = fh.read()
			try:
				self.__times = re.findall('(\d+) mn',data)
				self.__time = self.__times[0]
			except:
				self.__time = "Error"
			try:
				self.__dists = re.findall('(\d+.\d+) km',data)
				self.__dist = self.__dists[0]
			except:
				self.__dist = "Error"
			try:
				self.__fiabs = re.findall('(\d+) %',data)
				self.__fiab = self.__fiabs[0]
			except:
				self.__fiab = "Error"

		else:
			self.__time = "Error"
			self.__dist = "Error"
			self.__fiab = "Error"
		
		f = urllib.urlopen("http://www.sytadin.tm.fr/tempsreel/idf.txt")
		try:
			f.readline()
			f.readline()
			f.readline()
			f.readline()
			traffic = f.readline()
			if traffic == "Faible\n":
				self.__traffic = 1
			elif traffic == "Moyenne\n":
				self.__traffic = 2
			elif traffic == "Dense\n":
				self.__traffic = 3
			elif traffic == "Trs dense\n":
				self.__traffic = 4
			elif traffic == "Exceptionnel\n":
				self.__traffic = 5
			else:
				self.__traffic = 0
		except:
			self.__traffic = 0
		
		self._update("time")
		self._update("dist")
		self._update("fiab")
		self._update("traffic")
		
		self.__id_timer = self._add_timer(interv,self.__get_values)

	start = property(__get_start, __set_start, doc = "the start point")
	dest = property(__get_dest, __set_dest, doc = "the destination point")
	time = property(__get_time, doc = "the time needed for the trip in mn")
	dist = property(__get_dist, doc = "the distance for the trip in km")
	fiab = property(__get_fiab, doc = "the fiability of the info in %")
	interv = property(__get_interv, __set_interv, doc = "the interval of refresh in mn")
	traffic = property(__get_traffic, doc = "the traffic level, from 0 [unknown] to 5 [exceptional]")

def get_class(): return Sytadin
