#include <gfc/main.hh>
#include <gfc/gtk/entry.hh>
#include <gfc/gtk/selection.hh>
#include <gfc/gtk/togglebutton.hh>
#include <gfc/gtk/togglebuttonsignals.hh>
#include <gfc/gtk/invisible.hh>
#include <gfc/gtk/widgetsignals.hh>
#include <gfc/gtk/dialog.hh>

using namespace GFC;

// RetrieveSelectionButton

class RetrieveSelectionButton : public Gtk::Button, protected Gtk::WidgetSignals
{
protected:
	void on_get_target(Gtk::Entry *entry);
	virtual void on_selection_received(const Gtk::SelectionData& selection_data, unsigned int time);

public:
	RetrieveSelectionButton(Gtk::Entry *entry);
	virtual ~RetrieveSelectionButton();
};

// SupplySelectionButton

class SupplySelectionButton : public Gtk::ToggleButton, protected Gtk::ToggleButtonSignals
{
	static std::vector<Gtk::TargetEntry> target_entries;
	
	Gtk::Invisible *selection_widget;
	String target_string;

protected:
	virtual void on_toggled();
	void selection_get(Gtk::SelectionData& selection_data, unsigned int info, unsigned int time);
	bool selection_clear_event(const Gdk::EventSelection& event);

public:
	SupplySelectionButton();
	virtual ~SupplySelectionButton();
};

// SelectionTest

class SelectionTest : public Gtk::Dialog
{
public:
	SelectionTest();
	virtual ~SelectionTest();
};

