/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  hyperlink.cc - AtkHyperlink C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hyperlink.hh"
#include "private/marshal.hh"
#include "object.hh"

using namespace GFC;

/*  Atk::Hyperlink
 */

Atk::Hyperlink::Hyperlink(AtkHyperlink *hyperlink, bool owns_reference)
: G::Object((GObject*)hyperlink, owns_reference)
{
}
	
Atk::Hyperlink::~Hyperlink() 
{
}
	
String
Atk::Hyperlink::get_uri(int i) const
{
	char *uri = atk_hyperlink_get_uri(atk_hyperlink(), i);
	String s(uri);
	g_free(uri);
	return s;
}

Atk::Object*
Atk::Hyperlink::get_object(int i) const
{
	AtkObject *object = atk_hyperlink_get_object(atk_hyperlink(), i);
	return object ? G::Object::wrap<Atk::Object>(object) : 0;
}

/*  Atk::Hyperlink signals
 */

const Atk::Hyperlink::LinkActivatedSignalType Atk::Hyperlink::link_activated_signal("link_activated", (GCallback)&G::Marshal::void_callback);

