/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  pixbuf-loader.cc - GdkPixbufLoader C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "pixbuf-loader.hh"
#include "private/pixbuf-loaderclass.hh"
#include "pixbuf.hh"
#include "pixbuf-animation.hh"
#include <gfc/glib/error.hh>
#include <gfc/glib/private/marshal.hh>

using namespace GFC;

/*  Gdk::PixbufLoader
 */

Gdk::PixbufLoader::PixbufLoader(GdkPixbufLoader *pixbuf_loader, bool owns_reference)
: G::Object((GObject*)pixbuf_loader, owns_reference)
{
}
	
Gdk::PixbufLoader::PixbufLoader() 
: G::Object((GObject*)PixbufLoaderClass::create())
{
}

Gdk::PixbufLoader::~PixbufLoader()
{
}

Pointer<Gdk::PixbufLoader>
Gdk::PixbufLoader::create_with_type(const char *image_type, G::Error *error)
{
	return G::Object::wrap<PixbufLoader>(gdk_pixbuf_loader_new_with_type(image_type, *error));
}

Pointer<Gdk::PixbufLoader>
Gdk::PixbufLoader::create_with_type(const String& image_type, G::Error *error)
{
	return create_with_type(image_type.c_str(), error);
}

Pointer<Gdk::PixbufLoader>
Gdk::PixbufLoader::create_with_mime_type(const char *mime_type, G::Error *error)
{
	return G::Object::wrap<PixbufLoader>(gdk_pixbuf_loader_new_with_mime_type(mime_type, *error));
}

Pointer<Gdk::PixbufLoader>
Gdk::PixbufLoader::create_with_mime_type(const String& mime_type, G::Error *error)
{
	return create_with_mime_type(mime_type.c_str(), error);
}

Pointer<Gdk::Pixbuf>
Gdk::PixbufLoader::get_pixbuf() const
{
	GdkPixbuf *pixbuf = gdk_pixbuf_loader_get_pixbuf(gdk_pixbuf_loader());
	return pixbuf ? G::Object::wrap_new<Pixbuf>(pixbuf) : 0;
}

Pointer<Gdk::PixbufAnimation>
Gdk::PixbufLoader::get_animation() const
{
	GdkPixbufAnimation *animation = gdk_pixbuf_loader_get_animation(gdk_pixbuf_loader());
	return animation ? G::Object::wrap_new<PixbufAnimation>(animation) : 0;
}

Pointer<Gdk::PixbufFormat>
Gdk::PixbufLoader::get_format() const
{
	return new PixbufFormat(gdk_pixbuf_loader_get_format(gdk_pixbuf_loader()));
}

bool
Gdk::PixbufLoader::write(const unsigned char *buffer, size_t count, G::Error *error)
{
	return gdk_pixbuf_loader_write(gdk_pixbuf_loader(), buffer, count, *error);
}

bool
Gdk::PixbufLoader::close(G::Error *error)
{
	return gdk_pixbuf_loader_close(gdk_pixbuf_loader(), *error);
}

/*  Gdk::PixbufLoader signals
 */

const Gdk::PixbufLoader::SizePreparedSignalType Gdk::PixbufLoader::size_prepared_signal("size_prepared", (GCallback)&G::Marshal::void_int_int_callback);

const Gdk::PixbufLoader::AreaPreparedSignalType Gdk::PixbufLoader::area_prepared_signal("area_prepared", (GCallback)&G::Marshal::void_callback);

const Gdk::PixbufLoader::AreaUpdatedSignalType Gdk::PixbufLoader::area_updated_signal("area_updated", (GCallback)&G::Marshal::void_int_int_int_int_callback);

const Gdk::PixbufLoader::ClosedSignalType Gdk::PixbufLoader::closed_signal("closed", (GCallback)&G::Marshal::void_callback);

