/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  cellrenderer.cc - GtkCellRenderer C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderer.hh"
#include "private/marshal.hh"
#include "celleditable.hh"
#include "widget.hh"
#include "../gdk/color.hh"
#include "../gdk/types.hh"
#include "../gdk/window.hh"

using namespace GFC;

/*  Gtk::CellRenderer
 */

Gtk::CellRenderer::CellRenderer(GtkCellRenderer *cell, bool owns_reference)
: Object((GtkObject*)cell, owns_reference)
{
}
	
Gtk::CellRenderer::~CellRenderer() 
{
}
	
void
Gtk::CellRenderer::get_size(const Widget& widget, const Gdk::Rectangle *cell_area,
                            int *x_offset, int *y_offset, int *width, int *height) const
{
	gtk_cell_renderer_get_size(gtk_cell_renderer(), widget.gtk_widget(), *cell_area, x_offset, y_offset, width, height);
}

void
Gtk::CellRenderer::render(Gdk::Window& window, Widget& widget, const Gdk::Rectangle *background_area,
                          const Gdk::Rectangle *cell_area, const Gdk::Rectangle *expose_area,
                          CellRendererStateField flags)
{
	gtk_cell_renderer_render(gtk_cell_renderer(), window.gdk_window(), widget.gtk_widget(), *background_area,
	                         *cell_area, *expose_area, (GtkCellRendererState)flags);
}

bool
Gtk::CellRenderer::activate(const Gdk::Event *event, Widget *widget, const String& path,
                            const Gdk::Rectangle *background_area, const Gdk::Rectangle *cell_area,
							CellRendererStateField flags)
{
	return gtk_cell_renderer_activate(gtk_cell_renderer(), *event, *widget, path.c_str(), *background_area, *cell_area,
	                                  (GtkCellRendererState)flags);
}

Pointer<Gtk::CellEditable>
Gtk::CellRenderer::start_editing(const Gdk::Event *event, Widget *widget, const String& path,
                                 const Gdk::Rectangle *background_area, const Gdk::Rectangle *cell_area,
                                 CellRendererStateField flags)
{
	GtkCellEditable *cell_editable = gtk_cell_renderer_start_editing(gtk_cell_renderer(), *event, *widget, path.c_str(),
	                                                                 *background_area, *cell_area, (GtkCellRendererState)flags);
	Widget *tmp_widget = G::Object::wrap<Widget>(GTK_WIDGET(cell_editable));
	return tmp_widget ? dynamic_cast<CellEditable*>(tmp_widget) : 0;
}

/*  Gtk::CellRenderer properties
 */

const Gtk::CellRenderer::ModePropertyType Gtk::CellRenderer::mode_property("mode");

const Gtk::CellRenderer::VisiblePropertyType Gtk::CellRenderer::visible_property("visible");

const Gtk::CellRenderer::XAlignPropertyType Gtk::CellRenderer::xalign_property("xalign");

const Gtk::CellRenderer::YAlignPropertyType Gtk::CellRenderer::yalign_property("yalign");

const Gtk::CellRenderer::XPadPropertyType Gtk::CellRenderer::xpad_property("xpad");

const Gtk::CellRenderer::YPadPropertyType Gtk::CellRenderer::ypad_property("ypad");

const Gtk::CellRenderer::WidthPropertyType Gtk::CellRenderer::width_property("width");

const Gtk::CellRenderer::HeightPropertyType Gtk::CellRenderer::height_property("height");

const Gtk::CellRenderer::IsExpanderPropertyType Gtk::CellRenderer::is_expander_property("is_expander");

const Gtk::CellRenderer::IsExpandedPropertyType Gtk::CellRenderer::is_expanded_property("is_expanded");

const Gtk::CellRenderer::CellBackgroundPropertyType Gtk::CellRenderer::cell_background_property("cell_background");

const Gtk::CellRenderer::CellBackgroundGdkPropertyType Gtk::CellRenderer::cell_background_gdk_property("cell_background_gdk");

const Gtk::CellRenderer::CellBackgroundSetPropertyType Gtk::CellRenderer::cell_background_set_property("cell_background_set");

/*  Gtk::CellRenderer signals
 */

const Gtk::CellRenderer::EditingCanceledSignalType Gtk::CellRenderer::editing_canceled_signal("editing-canceled", (GCallback)&Marshal::void_string_callback);

