/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  fontbutton.cc - GtkFontButton C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "fontbutton.hh"
#include "private/fontbuttonclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::FontButton
 */

Gtk::FontButton::FontButton(GtkFontButton *font_button, bool owns_reference)
: Button((GtkButton*)font_button, owns_reference)
{
}

Gtk::FontButton::FontButton()
: Button((GtkButton*)FontButtonClass::create())
{
}
	
Gtk::FontButton::FontButton(const char *fontname)
: Button((GtkButton*)FontButtonClass::create())
{
	set_font_name(fontname);
}

Gtk::FontButton::FontButton(const String& fontname)
: Button((GtkButton*)FontButtonClass::create())
{
	set_font_name(fontname);
}

Gtk::FontButton::~FontButton()
{
}

String 
Gtk::FontButton::get_title() const
{
	return gtk_font_button_get_title(gtk_font_button());
}

String 
Gtk::FontButton::get_font_name() const
{
	return gtk_font_button_get_font_name(gtk_font_button());
}

void 
Gtk::FontButton::set_title(const String& title)
{
	set_title(title.c_str());
}

bool 
Gtk::FontButton::set_font_name(const String& fontname)
{
	return set_font_name(fontname.c_str());
}

/*  Gtk::FontButton signals
 */

const Gtk::FontButton::FontSetSignalType Gtk::FontButton::font_set_signal("font_set", (GCallback)&G::Marshal::void_callback);

