from docutils.writers import html4css1
import docutils
import docutils.core
import os
import sys
import parser
import time

def date():
    return time.strftime("%Y/%m/%d %H:%M:%S")


libversion = ""

news_depth = None
# HTML
config_base = os.getenv('GGIWWW', 'http://www.ggi-project.org')
config_prefix = '' # '<img style="position: absolute; left:10%%; top: 4px;" src="%s/images/ggi_logo.png" alt="General Graphics Interface"/><div style="height: 10px;" />'%config_base

# main navigation menu
config_menu = [ (config_base+'/index.html', 'Home'),
                (config_base+'/packages/index.html', 'Packages'),
                (config_base+'/documentation/index.html', 'Documentation'),
                (config_base+'/releases/index.html', 'Releases'),
                (config_base+'/contact.html', 'Contact') ]

config_suffix = '''
<div class="separator">&nbsp;</div>
<div style="margin-top: 8px; text-align: right;">
<a href="http://ibiblio.org">
<img width="88" src="http://www.ibiblio.org/images/ibiblio_logo.gif" height="31" alt="ibiblio" />
</a>

<a href="http://sourceforge.net/projects/ggi">
<img width="88" src="http://sourceforge.net/sflogo.php?group_id=16307" height="31" alt="Sourceforge" />
</a>

<a href="http://www.w3.org">
<img src="http://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0!" height="31" width="88" />
</a>

<a href="http://www.w3.org">
<img src="http://jigsaw.w3.org/css-validator/images/vcss.gif" alt="Valid CSS!" height="31" width="88" />
</a>
</div>
'''

config_stylesheet = file('ggi.css').read()

def menu2html(menu):
    s=[]
    for k,v in menu:
        s.append(' <a href="%s">%s</a> '%(k,v))
    return '<div class="menu">[%s]</div>'%'::'.join(s)

#######################################################################
# Custom writers
#######################################################################

# Normal translator, save that it handle our news stuff
class Translator(html4css1.HTMLTranslator):

    embed_stylesheet = 1
    
    def __init__(self, document, prefix = config_prefix,
                 suffix = config_suffix, menu = config_menu):
        html4css1.HTMLTranslator.__init__(self, document)
        if prefix: self.body_prefix.append(prefix)
        if menu: self.body_prefix.append(menu2html(menu))
        if suffix: self.body_suffix.insert(0, suffix)
        self.body_suffix.append('''<div style="text-align: right; font-size: small;">%s</div>'''%date())
        self.stylesheet = [ '<style type="text/css">%s</style>'% config_stylesheet ]

    def visit_title(self, node):
        # We would prefer to have h2 following h1...
        if isinstance(node.parent, docutils.nodes.topic):
            self.body.append(
                self.starttag(node, 'p', '', CLASS='topic-title'))
            if node.parent.hasattr('id'):
                self.body.append(
                    self.starttag({}, 'a', '', name=node.parent['id']))
                self.context.append('</a></p>\n')
            else:
                self.context.append('</p>\n')
        elif isinstance(node.parent, docutils.nodes.sidebar):
            self.body.append(
                  self.starttag(node, 'p', '', CLASS='sidebar-title'))
            if node.parent.hasattr('id'):
                self.body.append(
                    self.starttag({}, 'a', '', name=node.parent['id']))
                self.context.append('</a></p>\n')
            else:
                self.context.append('</p>\n')
        elif self.section_level == 0:
            # document title
            self.head.append('<title>GGI - %s</title>\n'
                             % self.encode(node.astext()))
            self.body.append(self.starttag(node, 'h1', ''))
            self.context.append('</h1>\n')
        elif not news_depth == None and self.section_level == news_depth:
            # should be news
            self.body.append(
                self.starttag(node, 'h3', '', CLASS='news'))
            atts = {}
            if node.parent.hasattr('id'):
                atts['name'] = node.parent['id']
            if node.hasattr('refid'):
                atts['class'] = 'toc-backref'
                atts['href'] = '#' + node['refid']
                #self.body.append(self.starttag({}, 'a', '', **atts))
            self.context.append('</h3>\n')
        else:
            self.body.append(
                self.starttag(node, 'h%s' % str(int(self.section_level)+1), ''))
            atts = {}
            if node.parent.hasattr('id'):
                atts['name'] = node.parent['id']
            if node.hasattr('refid'):
                atts['class'] = 'toc-backref'
                atts['href'] = '#' + node['refid']
                #self.body.append(self.starttag({}, 'a', '', **atts))
            self.context.append('</h%s>\n' % str(int(self.section_level)+1) )

    def visit_literal(self, node):
        a = getattr(node, 'ggi_ref', None)
        if a:
            for k, v in self.document.manpages_entries.iteritems():
                if v['volume']==a[1] and (a[0] in v['links'] or (a[0] == v['page'])):
                    self.body.append('<a href="%s.%s.html">%s</a>'%(
                        v['page'], a[1], str(node[0])))
                    raise docutils.nodes.SkipNode
        html4css1.HTMLTranslator.visit_literal(self, node)

# only build the index for manpages...
class IndexTranslator(Translator):

    headtail = """
    <div>
    <table style="width: 100%%"><tr>
    <td style="font-weight: bold;">[ <a href="%s">up</a> ] </td>
    <td style="font-weight: bold; text-align: right;">%s</td>
    </tr></table>
    </div>
    """
    
    def __init__(self, document, prefix = config_prefix,
                 suffix = config_suffix, menu = None):
        Translator.__init__(self, document, menu = None, suffix = '<div class="separator">&nbsp;</div>',
                            prefix = self.headtail%("%s/documentation/"%config_base,
                                                    libversion))
        
    def depart_document(self, node):
        vol = {}
        for m in node.manpages_entries.itervalues():
            if not vol.has_key(m['volume']): vol[m['volume']] = []
            vol[m['volume']].append(m['page'])
            vol[m['volume']].extend(m['links'])
        k = vol.keys()
        k.sort()
        self.body.append('<h2>Manpage index</h2>')
        for i in k:
            vol[i].sort() 
            r =[ '<h3>Volume %s</h3><p>'%i ]
            r.append(', '.join(['<a href="%s.%s.html">%s</a>'%(n,i,n) for n in vol[i]]))
            r.append('</p>')
            self.body.extend(r)

    def visit_section(self, node):
        try:
            t = node.ggi_manpage
            self.body.append('<div><a href="%s.%s.html">%s</a></div>\n'%(t[0],
                                                                         t[1], node.document.manpages_entries[t]['title']))
        except Exception, e:
            html4css1.HTMLTranslator.visit_section(self, node)
            return
        raise docutils.nodes.SkipNode

    def depart_section(self, node):
        try:
            t = node.ggi_manpage
        except:
            html4css1.HTMLTranslator.depart_section(self, node)

# build each pages individualy.
class ManpageWriter(html4css1.Writer):
    #settings_default_overrides = { 'stylesheet': 'ggi.css' }

    headtail = """
    <div>
    <table style="width: 100%%"><tr>
    <td style="font-weight: bold;">[ <a href="%s">prev</a> :: <a href="%s"> next </a> :: <a href="%s">up</a> ]</td>
    <td style="font-weight: bold; text-align: right;">%s (%s)</td>
    </tr></table>
    </div>
    """
    
    def __init__(self, d):
        html4css1.Writer.__init__(self)
        self.path = d
        self.translator_class = IndexTranslator
        
    def translate(self):
        s = self.document.settings
        s.xml_declaration = '<?xml version="1.0" encoding="utf-8" ?>'
        s.embed_stylesheet = ''
        s.stylesheet_path = ''
        s.stylesheet = 'ggi.css'
        for e in [ self.document.manpages_entries[i]
                   for i in self.document.manpages ]:
            for l in e['links']:
                fn = os.path.join(self.path,l+'.'+e['volume'])+'.html'
                print "linking %s -> %s(%s) ..."%(fn, e['page'], e['volume'])
                os.system("rm -f %s"%fn)
                os.system("ln -s %s.%s.html %s"%(e['page'], e['volume'], fn))
                
            fn = os.path.join(self.path,e['page']+'.'+e['volume'])+'.html'
            print "writing %s ..."%fn
            f = open(fn,'w')


            idx = self.document.manpages.index((e['page'],e['volume']))
            prev = None
            next = None
            if idx == 0: prev = "index.html"
            if idx == len(self.document.manpages)-1: next = "index.html"
            if not prev:
                p = self.document.manpages_entries[
                    self.document.manpages[idx-1]]
                prev = "%s.%s.html"%(p['page'],p['volume'])
            if not next:
                p = self.document.manpages_entries[
                    self.document.manpages[idx+1]]
                next = "%s.%s.html"%(p['page'],p['volume'])

            pfx = self.headtail%(prev,next,"index.html",
                                 libversion, e['volume'])
            sfx = '<div class="separator">&nbsp;</div>'+self.headtail%(prev,next,"index.html", libversion, e['volume'])
            d = Translator(self.document, menu = None,
                           prefix = pfx,
                           suffix = sfx)
            e['node'].walkabout(d)
            f.write(d.astext())
            f.close()
        return html4css1.Writer.translate(self)

# write pages for site
class SiteWriter(html4css1.Writer):
#    settings_default_overrides = {
#        'stylesheet': os.getenv('GGIWWW',
#                                'http://www.ggi-project.org/')+'ggi.css' }
    def __init__(self):
        html4css1.Writer.__init__(self)
        self.translator_class = Translator

if __name__ == '__main__':
    outdir = sys.argv[2]
    if not os.path.isdir(outdir):
        os.makedirs(outdir)
    try:
        libversion = sys.argv[3]
    except:
        libversion = os.path.basename(sys.argv[1])
        if libversion.endswith('.txt'):
            libversion = libversion[:-4]
        libversion += "-current"
    docutils.core.publish_file(source = open(sys.argv[1]),
                               destination = open(os.path.join(outdir,'index.html'),'w'),
                               writer = ManpageWriter(outdir),
                               parser = parser.Parser())
