// W32_WND.H : write a short description here...

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

//#include "ghemicalconfig2.h"

#ifndef W32_WND_H
#define W32_WND_H

class w32_wnd;

#include <oglappth/base_wnd.h>

#include <vector>
using namespace std;

/*################################################################################################*/

// w32_wnd class encapsulates the properties of a Win32-window.

class w32_wnd :
	public base_wnd
{
	private:
	
	static vector<w32_wnd *> iv;	// instance vector
	static const char child_classname[];
	
	protected:
	
	HWND my_hwnd;		// window handle
	HDC my_hdc;		// device context handle
	
	HGLRC my_hrc;		// OpenGL rendering context handle
	HMENU my_popup;
	
	public:
	
	w32_wnd(void);
	~w32_wnd(void);
	
	static bool register_wnd_class(HINSTANCE);
	static bool unregister_wnd_class(HINSTANCE);
	
	static w32_wnd * iv_Find(HWND);
	
	static LRESULT CALLBACK child_wnd_proc(HWND, UINT, WPARAM, LPARAM);
	
	void RequestUpdate(bool);		// virtual
	void RequestResize(int, int);		// virtual
	
	bool SetCurrent(void);			// virtual
	
	protected:
	
	void TitleChanged(void);		// virtual
};

/*################################################################################################*/

#endif	// W32_WND_H

// eof
