/*
 * spi-private.h
 */

#ifndef __SPI_PRIVATE_H__
#define __SPI_PRIVATE_H__

#include <sys/time.h>
#include "windef.h"

typedef struct _picture_info {
  long left, top;   /* Ÿ */
  long width;       /* (pixel) */
  long height;      /* ι⤵(pixel) */
  WORD x_density;   /* Ǥοʿ̩ */
  WORD y_density;   /* Ǥοľ̩ */
  short colorDepth; /* bit */
  HLOCAL hInfo;     /* ΥƥȾ */
} PictureInfo;

#define SPI_SUCCESS            0 /* ｪλ */
#define SPI_UNIMPLEMENTED     -1 /* εǽϥץȤƤʤ */
#define SPI_CB_RETURNS_NONZERO 1 /* Хåؿ0֤ΤŸߤ */
#define SPI_UNKNOWN_FORMAT     2 /* ̤ΤΥեޥå */
#define SPI_BROKEN_DATA        3 /* ǡƤ */
#define SPI_NOENOUGH_MEMORY    4 /* ꡼ݽʤ */
#define SPI_MEMORY_ERROR       5 /* ꡼顼Lockʤ */
#define SPI_FILE_READ_ERROR    6 /* ե꡼ɥ顼 */
#define SPI_RESERVED           7 /* ͽ */
#define SPI_INTERNAL_ERROR     8 /* 顼 */

extern const char *spi_errormsg[];
extern int         spi_errormsg_num;

typedef int PASCAL (*ProgressCallback)(int, int, long);

typedef int PASCAL (*IsSupportedFunc)(LPSTR, DWORD);
typedef int PASCAL (*GetPluginInfoFunc)(int, LPSTR, int);
typedef int PASCAL (*GetPictureInfoFunc)(LPSTR, long, unsigned int, PictureInfo *);
typedef int PASCAL (*GetPictureFunc)(LPSTR, long, unsigned int, HANDLE *, HANDLE *, ProgressCallback, long);

typedef struct _file_info {
  unsigned char method[8]; /* ˡμ */
  unsigned long position;  /* եǤΰ */
  unsigned long compsize;  /* ̤줿 */
  unsigned long filesize;  /* Υե륵 */
  time_t timestamp;        /* եι */
  char path[200];          /* Хѥ */
  char filename[200];      /* ե͡ */
  unsigned long crc;       /* CRC */
} fileInfo;

typedef struct _BITMAPINFOHEADER {
  unsigned long       biSize;         /*  0: ¤ΤΥ(Х) */
  long                biWidth;        /*  4: ᡼ */
  long                biHeight;       /*  8: ᡼ι⤵ */
  unsigned short      biPlanes;       /* 12: must be 1 */
  unsigned short      biBitCount;     /* 14: 1pixelbit */
  unsigned long       biCompression;  /* 16: ̥ */
  unsigned long       biSizeImage;    /* 20: ᡼Υ */
  long                biXPixPerMeter; /* 24: ʿ */
  long                biYPixPerMeter; /* 28: ľ */
  unsigned long       biClrUsed;      /* 32: 顼ơ֥ط */
  unsigned long       biClrImportant; /* 36: 顼ơ֥ط */
} BITMAPINFOHEADER;

/* typedef int PASCAL (*IsSupportedFunc)(LPSTR, DWORD); */
/* typedef int PASCAL (*GetPluginInfoFunc)(int, LPSTR, int); */
typedef int PASCAL (*GetArchiveInfoFunc)(LPSTR, long, unsigned int, HLOCAL *);
typedef int PASCAL (*GetFileInfoFunc)(LPSTR, long, LPSTR, unsigned int, fileInfo *);
typedef int PASCAL (*GetFileFunc)(LPSTR, long, LPSTR, unsigned int, ProgressCallback, long);

#endif /* __SPI_PRIVATE_H__ */
