// $Id: label.cc,v 1.31 2003/04/24 08:20:41 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "label.hh"

static Gtk_Label Gtk_Label(false);

const std::string Gtk_Label::TypeName(const Widget &w) const
{  return GtkPrefix()+"Label";
}

const std::string Gtk_Label::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"label.h";
}

Gtk_Label::Gtk_Label(bool base_class_init)
{  if (!base_class_init) Writer["GtkLabel"]=this;
}

void Gtk_Label::ConstructionArgs(const Widget &w, CxxFile &f) const
{  std::string label=w.getProperty("label");
   f.FunctionArg() << Configuration.Translatable(label);
   if (GTKMM2 && w.getBoolProperty("use_underline")
  		&& ( label.find('_')!=std::string::npos ) )
      f.FunctionArg() << "true";
}

bool Gtk_Label::NeedExplicitCtor(const Widget &w) const
{  return w.hasProperty("label"); }

bool Gtk_Label::isInternalMethod(const Widget &w,std::string &method,const std::string &args,std::string &scope,bool &is_signal) const
{  const char prefix[]="gtk_label_";
   const int plen(sizeof(prefix)-1);
   if (method.substr(0,plen)==prefix) method=method.substr(plen);
   if (((method=="set_text" || method=="set") && matches("const std::string &\\_",args))
        || (method=="parse_uline" && matches("const std::string &\\_",args))
        || (method=="set_pattern" && matches("const std::string &\\_",args))
        || (method=="set_line_wrap" && matches("bool\\ \\_",args)))
   {  scope=Gtk_Label::TypeName(w);
      is_signal=false;
      return true;
   }
   return Parent::isInternalMethod(w,method,args,scope,is_signal);
}

void Gtk_Label::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);

   WriteEnumPropertyNS(w,f,instance, "justify");
   WriteBoolProperty(w,f,instance, "wrap", false, "line_wrap");
   if (GTKMM2) WriteBoolProperty(w,f,instance, "use_markup", false, "use_markup");
   if (GTKMM2) WriteBoolProperty(w,f,instance, "selectable", false);
   if (GTKMM2 && w.hasProperty("mnemonic_widget")) 
   {  f.Statement() << instance << "set_mnemonic_widget" << "(*"
   		<< Configuration.InstanceName(w.getProperty("mnemonic_widget"))
   		<< ')';
   }
}
