import sys
import socket
import network
import select

class Link(network.StateMachine):
    """
    """

    timeout = None
    
    def __init__(self, srcport, dstport):
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.address = ('localhost', dstport)
        self.socket.bind(('', srcport))
        self.socket.setblocking(False)
        network.StateMachine.__init__(self)
        print 'Listening on ' + str(srcport) + ', sending to ' + str(dstport)
    
    def onOutgoingMessage(self, message):
        print str(self.address) + ' << ' + repr(message)
        self.socket.sendto(message, self.address)
    
    def processMessage(self, messageType, fields):
        print (messageType, fields)
        
    def send(self, messageId):
        self.sendMessage(messageId, [('test1', 'FISH'), ('test2', 'I like space'), ('test3', 'i\nlike\nnewlines!')])

    def read(self):
        while True:
            try:
                (message, address) = self.socket.recvfrom(9999)
            except socket.error:
                return
            print str(address) + ' >> ' + repr(message)
            self.registerIncomingMessage(message)
            
    def startTimer(self):
        self.timeout = 10
        
    def stopTimer(self):
        self.timeout = None
            
    def tick(self):
        if self.timeout is None:
            return
        self.timeout -= 1
        if self.timeout < 0:
            self.retryMessage()
        
srcport = int(sys.argv[1])
dstport = int(sys.argv[2])
try:
    messageId = sys.argv[3]
except IndexError:
    messageId = None
l = Link(srcport, dstport)

j = 10
while True:
    select.select([], [], [], 0.1)
    l.read()
    j -= 1
    if j < 0 and messageId != None:
        l.send(messageId)
        j = 10
    l.tick()
